// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;

namespace Azure.ResourceManager.SecurityInsights.Models
{
    /// <summary> Template property bag. </summary>
    public partial class TemplateProperties : TemplateBaseProperties
    {
        /// <summary> Initializes a new instance of <see cref="TemplateProperties"/>. </summary>
        internal TemplateProperties()
        {
            DependantTemplates = new ChangeTrackingList<TemplateProperties>();
        }

        /// <summary> Initializes a new instance of <see cref="TemplateProperties"/>. </summary>
        /// <param name="contentId"> Static ID for the content.  Used to identify dependencies and content from solutions or community.  Hard-coded/static for out of the box content and solutions. Dynamic for user-created.  This is the resource name. </param>
        /// <param name="contentProductId"> Unique ID for the content. It should be generated based on the contentId of the package, contentId of the template, contentKind of the template and the contentVersion of the template. </param>
        /// <param name="packageVersion"> Version of the package.  Default and recommended format is numeric (e.g. 1, 1.0, 1.0.0, 1.0.0.0), following ARM metadata best practices.  Can also be any string, but then we cannot guarantee any version checks. </param>
        /// <param name="version"> Version of the content.  Default and recommended format is numeric (e.g. 1, 1.0, 1.0.0, 1.0.0.0), following ARM metadata best practices.  Can also be any string, but then we cannot guarantee any version checks. </param>
        /// <param name="displayName"> The display name of the template. </param>
        /// <param name="contentKind"> The kind of content the template is for. </param>
        /// <param name="source"> Source of the content.  This is where/how it was created. </param>
        /// <param name="author"> The creator of the content item. </param>
        /// <param name="support"> Support information for the template - type, name, contact information. </param>
        /// <param name="dependencies"> Dependencies for the content item, what other content items it requires to work.  Can describe more complex dependencies using a recursive/nested structure. For a single dependency an id/kind/version can be supplied or operator/criteria for complex formats. </param>
        /// <param name="categories"> Categories for the item. </param>
        /// <param name="providers"> Providers for the content item. </param>
        /// <param name="firstPublishOn"> first publish date content item. </param>
        /// <param name="lastPublishOn"> last publish date for the content item. </param>
        /// <param name="customVersion"> The custom version of the content. A optional free text. </param>
        /// <param name="contentSchemaVersion"> Schema version of the content. Can be used to distinguish between different flow based on the schema version. </param>
        /// <param name="icon"> the icon identifier. this id can later be fetched from the content metadata. </param>
        /// <param name="threatAnalysisTactics"> the tactics the resource covers. </param>
        /// <param name="threatAnalysisTechniques"> the techniques the resource covers, these have to be aligned with the tactics being used. </param>
        /// <param name="previewImages"> preview image file names. These will be taken from the solution artifacts. </param>
        /// <param name="previewImagesDark"> preview image file names. These will be taken from the solution artifacts. used for dark theme support. </param>
        /// <param name="packageId"> the package Id contains this template. </param>
        /// <param name="packageKind"> the packageKind of the package contains this template. </param>
        /// <param name="packageName"> the name of the package contains this template. </param>
        /// <param name="isDeprecated"> Flag indicates if this template is deprecated. </param>
        /// <param name="serializedAdditionalRawData"> Keeps track of any properties unknown to the library. </param>
        /// <param name="mainTemplate"> The JSON of the ARM template to deploy active content. Expandable. </param>
        /// <param name="dependantTemplates"> Dependant templates. Expandable. </param>
        internal TemplateProperties(string contentId, string contentProductId, string packageVersion, string version, string displayName, SecurityInsightsKind? contentKind, SecurityInsightsMetadataSource source, SecurityInsightsMetadataAuthor author, SecurityInsightsMetadataSupport support, SecurityInsightsMetadataDependencies dependencies, SecurityInsightsMetadataCategories categories, IReadOnlyList<string> providers, DateTimeOffset? firstPublishOn, DateTimeOffset? lastPublishOn, string customVersion, string contentSchemaVersion, string icon, IReadOnlyList<string> threatAnalysisTactics, IReadOnlyList<string> threatAnalysisTechniques, IReadOnlyList<string> previewImages, IReadOnlyList<string> previewImagesDark, string packageId, SecurityInsightsMetadataPackageKind? packageKind, string packageName, SecurityInsightsMetadataFlag? isDeprecated, IDictionary<string, BinaryData> serializedAdditionalRawData, BinaryData mainTemplate, IReadOnlyList<TemplateProperties> dependantTemplates) : base(contentId, contentProductId, packageVersion, version, displayName, contentKind, source, author, support, dependencies, categories, providers, firstPublishOn, lastPublishOn, customVersion, contentSchemaVersion, icon, threatAnalysisTactics, threatAnalysisTechniques, previewImages, previewImagesDark, packageId, packageKind, packageName, isDeprecated, serializedAdditionalRawData)
        {
            MainTemplate = mainTemplate;
            DependantTemplates = dependantTemplates;
        }

        /// <summary>
        /// The JSON of the ARM template to deploy active content. Expandable.
        /// <para>
        /// To assign an object to this property use <see cref="BinaryData.FromObjectAsJson{T}(T, System.Text.Json.JsonSerializerOptions?)"/>.
        /// </para>
        /// <para>
        /// To assign an already formatted json string to this property use <see cref="BinaryData.FromString(string)"/>.
        /// </para>
        /// <para>
        /// Examples:
        /// <list type="bullet">
        /// <item>
        /// <term>BinaryData.FromObjectAsJson("foo")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("\"foo\"")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromObjectAsJson(new { key = "value" })</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("{\"key\": \"value\"}")</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// </list>
        /// </para>
        /// </summary>
        [WirePath("mainTemplate")]
        public BinaryData MainTemplate { get; }
        /// <summary> Dependant templates. Expandable. </summary>
        [WirePath("dependantTemplates")]
        public IReadOnlyList<TemplateProperties> DependantTemplates { get; }
    }
}
