// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;

namespace Azure.ResourceManager.SecurityInsights.Models
{
    /// <summary> Describes team information. </summary>
    public partial class TeamInformation
    {
        /// <summary>
        /// Keeps track of any properties unknown to the library.
        /// <para>
        /// To assign an object to the value of this property use <see cref="BinaryData.FromObjectAsJson{T}(T, System.Text.Json.JsonSerializerOptions?)"/>.
        /// </para>
        /// <para>
        /// To assign an already formatted json string to this property use <see cref="BinaryData.FromString(string)"/>.
        /// </para>
        /// <para>
        /// Examples:
        /// <list type="bullet">
        /// <item>
        /// <term>BinaryData.FromObjectAsJson("foo")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("\"foo\"")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromObjectAsJson(new { key = "value" })</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("{\"key\": \"value\"}")</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// </list>
        /// </para>
        /// </summary>
        private IDictionary<string, BinaryData> _serializedAdditionalRawData;

        /// <summary> Initializes a new instance of <see cref="TeamInformation"/>. </summary>
        public TeamInformation()
        {
        }

        /// <summary> Initializes a new instance of <see cref="TeamInformation"/>. </summary>
        /// <param name="teamId"> Team ID. </param>
        /// <param name="primaryChannelUri"> The primary channel URL of the team. </param>
        /// <param name="teamCreationTimeUtc"> The time the team was created. </param>
        /// <param name="name"> The name of the team. </param>
        /// <param name="description"> The description of the team. </param>
        /// <param name="serializedAdditionalRawData"> Keeps track of any properties unknown to the library. </param>
        internal TeamInformation(string teamId, Uri primaryChannelUri, DateTimeOffset? teamCreationTimeUtc, string name, string description, IDictionary<string, BinaryData> serializedAdditionalRawData)
        {
            TeamId = teamId;
            PrimaryChannelUri = primaryChannelUri;
            TeamCreationTimeUtc = teamCreationTimeUtc;
            Name = name;
            Description = description;
            _serializedAdditionalRawData = serializedAdditionalRawData;
        }

        /// <summary> Team ID. </summary>
        [WirePath("teamId")]
        public string TeamId { get; }
        /// <summary> The primary channel URL of the team. </summary>
        [WirePath("primaryChannelUrl")]
        public Uri PrimaryChannelUri { get; }
        /// <summary> The time the team was created. </summary>
        [WirePath("teamCreationTimeUtc")]
        public DateTimeOffset? TeamCreationTimeUtc { get; }
        /// <summary> The name of the team. </summary>
        [WirePath("name")]
        public string Name { get; }
        /// <summary> The description of the team. </summary>
        [WirePath("description")]
        public string Description { get; }
    }
}
