// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ComponentModel;

namespace Azure.ResourceManager.SecurityInsights.Models
{
    /// <summary> The kind of the TI object. </summary>
    internal readonly partial struct TIObjectKind : IEquatable<TIObjectKind>
    {
        private readonly string _value;

        /// <summary> Initializes a new instance of <see cref="TIObjectKind"/>. </summary>
        /// <exception cref="ArgumentNullException"> <paramref name="value"/> is null. </exception>
        public TIObjectKind(string value)
        {
            _value = value ?? throw new ArgumentNullException(nameof(value));
        }

        private const string AttackPatternValue = "AttackPattern";
        private const string IdentityValue = "Identity";
        private const string IndicatorValue = "Indicator";
        private const string RelationshipValue = "Relationship";
        private const string ThreatActorValue = "ThreatActor";

        /// <summary> A TI object that represents an attack pattern. </summary>
        public static TIObjectKind AttackPattern { get; } = new TIObjectKind(AttackPatternValue);
        /// <summary> A TI object that represents an identity. </summary>
        public static TIObjectKind Identity { get; } = new TIObjectKind(IdentityValue);
        /// <summary> A TI object that represents an indicator. </summary>
        public static TIObjectKind Indicator { get; } = new TIObjectKind(IndicatorValue);
        /// <summary> A TI object that represents a relationship between two TI objects. </summary>
        public static TIObjectKind Relationship { get; } = new TIObjectKind(RelationshipValue);
        /// <summary> A TI object that represents a threat actor. </summary>
        public static TIObjectKind ThreatActor { get; } = new TIObjectKind(ThreatActorValue);
        /// <summary> Determines if two <see cref="TIObjectKind"/> values are the same. </summary>
        public static bool operator ==(TIObjectKind left, TIObjectKind right) => left.Equals(right);
        /// <summary> Determines if two <see cref="TIObjectKind"/> values are not the same. </summary>
        public static bool operator !=(TIObjectKind left, TIObjectKind right) => !left.Equals(right);
        /// <summary> Converts a <see cref="string"/> to a <see cref="TIObjectKind"/>. </summary>
        public static implicit operator TIObjectKind(string value) => new TIObjectKind(value);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override bool Equals(object obj) => obj is TIObjectKind other && Equals(other);
        /// <inheritdoc />
        public bool Equals(TIObjectKind other) => string.Equals(_value, other._value, StringComparison.InvariantCultureIgnoreCase);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override int GetHashCode() => _value != null ? StringComparer.InvariantCultureIgnoreCase.GetHashCode(_value) : 0;
        /// <inheritdoc />
        public override string ToString() => _value;
    }
}
