// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ComponentModel;

namespace Azure.ResourceManager.SecurityInsights.Models
{
    /// <summary> The version of the source control. </summary>
    public readonly partial struct SourceControlVersion : IEquatable<SourceControlVersion>
    {
        private readonly string _value;

        /// <summary> Initializes a new instance of <see cref="SourceControlVersion"/>. </summary>
        /// <exception cref="ArgumentNullException"> <paramref name="value"/> is null. </exception>
        public SourceControlVersion(string value)
        {
            _value = value ?? throw new ArgumentNullException(nameof(value));
        }

        private const string V1Value = "V1";
        private const string V2Value = "V2";

        /// <summary> V1. </summary>
        public static SourceControlVersion V1 { get; } = new SourceControlVersion(V1Value);
        /// <summary> V2. </summary>
        public static SourceControlVersion V2 { get; } = new SourceControlVersion(V2Value);
        /// <summary> Determines if two <see cref="SourceControlVersion"/> values are the same. </summary>
        public static bool operator ==(SourceControlVersion left, SourceControlVersion right) => left.Equals(right);
        /// <summary> Determines if two <see cref="SourceControlVersion"/> values are not the same. </summary>
        public static bool operator !=(SourceControlVersion left, SourceControlVersion right) => !left.Equals(right);
        /// <summary> Converts a <see cref="string"/> to a <see cref="SourceControlVersion"/>. </summary>
        public static implicit operator SourceControlVersion(string value) => new SourceControlVersion(value);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override bool Equals(object obj) => obj is SourceControlVersion other && Equals(other);
        /// <inheritdoc />
        public bool Equals(SourceControlVersion other) => string.Equals(_value, other._value, StringComparison.InvariantCultureIgnoreCase);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override int GetHashCode() => _value != null ? StringComparer.InvariantCultureIgnoreCase.GetHashCode(_value) : 0;
        /// <inheritdoc />
        public override string ToString() => _value;
    }
}
