// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ComponentModel;

namespace Azure.ResourceManager.SecurityInsights.Models
{
    /// <summary> The type of repository. </summary>
    public readonly partial struct SourceControlOperationWarningCode : IEquatable<SourceControlOperationWarningCode>
    {
        private readonly string _value;

        /// <summary> Initializes a new instance of <see cref="SourceControlOperationWarningCode"/>. </summary>
        /// <exception cref="ArgumentNullException"> <paramref name="value"/> is null. </exception>
        public SourceControlOperationWarningCode(string value)
        {
            _value = value ?? throw new ArgumentNullException(nameof(value));
        }

        private const string SourceControlWarningDeleteServicePrincipalValue = "SourceControlWarning_DeleteServicePrincipal";
        private const string SourceControlWarningDeletePipelineFromAzureDevOpsValue = "SourceControlWarning_DeletePipelineFromAzureDevOps";
        private const string SourceControlWarningDeleteWorkflowAndSecretFromGitHubValue = "SourceControlWarning_DeleteWorkflowAndSecretFromGitHub";
        private const string SourceControlWarningDeleteRoleAssignmentValue = "SourceControlWarning_DeleteRoleAssignment";
        private const string SourceControlDeletedWithWarningsValue = "SourceControl_DeletedWithWarnings";

        /// <summary> SourceControlWarning_DeleteServicePrincipal. </summary>
        public static SourceControlOperationWarningCode SourceControlWarningDeleteServicePrincipal { get; } = new SourceControlOperationWarningCode(SourceControlWarningDeleteServicePrincipalValue);
        /// <summary> SourceControlWarning_DeletePipelineFromAzureDevOps. </summary>
        public static SourceControlOperationWarningCode SourceControlWarningDeletePipelineFromAzureDevOps { get; } = new SourceControlOperationWarningCode(SourceControlWarningDeletePipelineFromAzureDevOpsValue);
        /// <summary> SourceControlWarning_DeleteWorkflowAndSecretFromGitHub. </summary>
        public static SourceControlOperationWarningCode SourceControlWarningDeleteWorkflowAndSecretFromGitHub { get; } = new SourceControlOperationWarningCode(SourceControlWarningDeleteWorkflowAndSecretFromGitHubValue);
        /// <summary> SourceControlWarning_DeleteRoleAssignment. </summary>
        public static SourceControlOperationWarningCode SourceControlWarningDeleteRoleAssignment { get; } = new SourceControlOperationWarningCode(SourceControlWarningDeleteRoleAssignmentValue);
        /// <summary> SourceControl_DeletedWithWarnings. </summary>
        public static SourceControlOperationWarningCode SourceControlDeletedWithWarnings { get; } = new SourceControlOperationWarningCode(SourceControlDeletedWithWarningsValue);
        /// <summary> Determines if two <see cref="SourceControlOperationWarningCode"/> values are the same. </summary>
        public static bool operator ==(SourceControlOperationWarningCode left, SourceControlOperationWarningCode right) => left.Equals(right);
        /// <summary> Determines if two <see cref="SourceControlOperationWarningCode"/> values are not the same. </summary>
        public static bool operator !=(SourceControlOperationWarningCode left, SourceControlOperationWarningCode right) => !left.Equals(right);
        /// <summary> Converts a <see cref="string"/> to a <see cref="SourceControlOperationWarningCode"/>. </summary>
        public static implicit operator SourceControlOperationWarningCode(string value) => new SourceControlOperationWarningCode(value);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override bool Equals(object obj) => obj is SourceControlOperationWarningCode other && Equals(other);
        /// <inheritdoc />
        public bool Equals(SourceControlOperationWarningCode other) => string.Equals(_value, other._value, StringComparison.InvariantCultureIgnoreCase);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override int GetHashCode() => _value != null ? StringComparer.InvariantCultureIgnoreCase.GetHashCode(_value) : 0;
        /// <inheritdoc />
        public override string ToString() => _value;
    }
}
