// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ComponentModel;

namespace Azure.ResourceManager.SecurityInsights.Models
{
    /// <summary> The current state of the deployment. </summary>
    public readonly partial struct SourceControlDeploymentState : IEquatable<SourceControlDeploymentState>
    {
        private readonly string _value;

        /// <summary> Initializes a new instance of <see cref="SourceControlDeploymentState"/>. </summary>
        /// <exception cref="ArgumentNullException"> <paramref name="value"/> is null. </exception>
        public SourceControlDeploymentState(string value)
        {
            _value = value ?? throw new ArgumentNullException(nameof(value));
        }

        private const string InProgressValue = "In_Progress";
        private const string CompletedValue = "Completed";
        private const string QueuedValue = "Queued";
        private const string CancelingValue = "Canceling";

        /// <summary> In_Progress. </summary>
        public static SourceControlDeploymentState InProgress { get; } = new SourceControlDeploymentState(InProgressValue);
        /// <summary> Completed. </summary>
        public static SourceControlDeploymentState Completed { get; } = new SourceControlDeploymentState(CompletedValue);
        /// <summary> Queued. </summary>
        public static SourceControlDeploymentState Queued { get; } = new SourceControlDeploymentState(QueuedValue);
        /// <summary> Canceling. </summary>
        public static SourceControlDeploymentState Canceling { get; } = new SourceControlDeploymentState(CancelingValue);
        /// <summary> Determines if two <see cref="SourceControlDeploymentState"/> values are the same. </summary>
        public static bool operator ==(SourceControlDeploymentState left, SourceControlDeploymentState right) => left.Equals(right);
        /// <summary> Determines if two <see cref="SourceControlDeploymentState"/> values are not the same. </summary>
        public static bool operator !=(SourceControlDeploymentState left, SourceControlDeploymentState right) => !left.Equals(right);
        /// <summary> Converts a <see cref="string"/> to a <see cref="SourceControlDeploymentState"/>. </summary>
        public static implicit operator SourceControlDeploymentState(string value) => new SourceControlDeploymentState(value);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override bool Equals(object obj) => obj is SourceControlDeploymentState other && Equals(other);
        /// <inheritdoc />
        public bool Equals(SourceControlDeploymentState other) => string.Equals(_value, other._value, StringComparison.InvariantCultureIgnoreCase);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override int GetHashCode() => _value != null ? StringComparer.InvariantCultureIgnoreCase.GetHashCode(_value) : 0;
        /// <inheritdoc />
        public override string ToString() => _value;
    }
}
