// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;

namespace Azure.ResourceManager.SecurityInsights.Models
{
    /// <summary> Information regarding a deployment. </summary>
    public partial class SourceControlDeploymentInfo
    {
        /// <summary>
        /// Keeps track of any properties unknown to the library.
        /// <para>
        /// To assign an object to the value of this property use <see cref="BinaryData.FromObjectAsJson{T}(T, System.Text.Json.JsonSerializerOptions?)"/>.
        /// </para>
        /// <para>
        /// To assign an already formatted json string to this property use <see cref="BinaryData.FromString(string)"/>.
        /// </para>
        /// <para>
        /// Examples:
        /// <list type="bullet">
        /// <item>
        /// <term>BinaryData.FromObjectAsJson("foo")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("\"foo\"")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromObjectAsJson(new { key = "value" })</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("{\"key\": \"value\"}")</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// </list>
        /// </para>
        /// </summary>
        private IDictionary<string, BinaryData> _serializedAdditionalRawData;

        /// <summary> Initializes a new instance of <see cref="SourceControlDeploymentInfo"/>. </summary>
        internal SourceControlDeploymentInfo()
        {
        }

        /// <summary> Initializes a new instance of <see cref="SourceControlDeploymentInfo"/>. </summary>
        /// <param name="deploymentFetchStatus"> Status while fetching the last deployment. </param>
        /// <param name="deployment"> Deployment information. </param>
        /// <param name="message"> Additional details about the deployment that can be shown to the user. </param>
        /// <param name="serializedAdditionalRawData"> Keeps track of any properties unknown to the library. </param>
        internal SourceControlDeploymentInfo(SourceControlDeploymentFetchStatus? deploymentFetchStatus, SourceControlDeployment deployment, string message, IDictionary<string, BinaryData> serializedAdditionalRawData)
        {
            DeploymentFetchStatus = deploymentFetchStatus;
            Deployment = deployment;
            Message = message;
            _serializedAdditionalRawData = serializedAdditionalRawData;
        }

        /// <summary> Status while fetching the last deployment. </summary>
        [WirePath("deploymentFetchStatus")]
        public SourceControlDeploymentFetchStatus? DeploymentFetchStatus { get; }
        /// <summary> Deployment information. </summary>
        [WirePath("deployment")]
        public SourceControlDeployment Deployment { get; }
        /// <summary> Additional details about the deployment that can be shown to the user. </summary>
        [WirePath("message")]
        public string Message { get; }
    }
}
