// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ComponentModel;

namespace Azure.ResourceManager.SecurityInsights.Models
{
    /// <summary> Status while trying to fetch the deployment information. </summary>
    public readonly partial struct SourceControlDeploymentFetchStatus : IEquatable<SourceControlDeploymentFetchStatus>
    {
        private readonly string _value;

        /// <summary> Initializes a new instance of <see cref="SourceControlDeploymentFetchStatus"/>. </summary>
        /// <exception cref="ArgumentNullException"> <paramref name="value"/> is null. </exception>
        public SourceControlDeploymentFetchStatus(string value)
        {
            _value = value ?? throw new ArgumentNullException(nameof(value));
        }

        private const string SuccessValue = "Success";
        private const string UnauthorizedValue = "Unauthorized";
        private const string NotFoundValue = "NotFound";

        /// <summary> Success. </summary>
        public static SourceControlDeploymentFetchStatus Success { get; } = new SourceControlDeploymentFetchStatus(SuccessValue);
        /// <summary> Unauthorized. </summary>
        public static SourceControlDeploymentFetchStatus Unauthorized { get; } = new SourceControlDeploymentFetchStatus(UnauthorizedValue);
        /// <summary> NotFound. </summary>
        public static SourceControlDeploymentFetchStatus NotFound { get; } = new SourceControlDeploymentFetchStatus(NotFoundValue);
        /// <summary> Determines if two <see cref="SourceControlDeploymentFetchStatus"/> values are the same. </summary>
        public static bool operator ==(SourceControlDeploymentFetchStatus left, SourceControlDeploymentFetchStatus right) => left.Equals(right);
        /// <summary> Determines if two <see cref="SourceControlDeploymentFetchStatus"/> values are not the same. </summary>
        public static bool operator !=(SourceControlDeploymentFetchStatus left, SourceControlDeploymentFetchStatus right) => !left.Equals(right);
        /// <summary> Converts a <see cref="string"/> to a <see cref="SourceControlDeploymentFetchStatus"/>. </summary>
        public static implicit operator SourceControlDeploymentFetchStatus(string value) => new SourceControlDeploymentFetchStatus(value);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override bool Equals(object obj) => obj is SourceControlDeploymentFetchStatus other && Equals(other);
        /// <inheritdoc />
        public bool Equals(SourceControlDeploymentFetchStatus other) => string.Equals(_value, other._value, StringComparison.InvariantCultureIgnoreCase);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override int GetHashCode() => _value != null ? StringComparer.InvariantCultureIgnoreCase.GetHashCode(_value) : 0;
        /// <inheritdoc />
        public override string ToString() => _value;
    }
}
