// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;

namespace Azure.ResourceManager.SecurityInsights.Models
{
    /// <summary> Description about a deployment. </summary>
    public partial class SourceControlDeployment
    {
        /// <summary>
        /// Keeps track of any properties unknown to the library.
        /// <para>
        /// To assign an object to the value of this property use <see cref="BinaryData.FromObjectAsJson{T}(T, System.Text.Json.JsonSerializerOptions?)"/>.
        /// </para>
        /// <para>
        /// To assign an already formatted json string to this property use <see cref="BinaryData.FromString(string)"/>.
        /// </para>
        /// <para>
        /// Examples:
        /// <list type="bullet">
        /// <item>
        /// <term>BinaryData.FromObjectAsJson("foo")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("\"foo\"")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromObjectAsJson(new { key = "value" })</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("{\"key\": \"value\"}")</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// </list>
        /// </para>
        /// </summary>
        private IDictionary<string, BinaryData> _serializedAdditionalRawData;

        /// <summary> Initializes a new instance of <see cref="SourceControlDeployment"/>. </summary>
        internal SourceControlDeployment()
        {
        }

        /// <summary> Initializes a new instance of <see cref="SourceControlDeployment"/>. </summary>
        /// <param name="deploymentId"> Deployment identifier. </param>
        /// <param name="deploymentState"> Current status of the deployment. </param>
        /// <param name="deploymentResult"> The outcome of the deployment. </param>
        /// <param name="deploymentOn"> The time when the deployment finished. </param>
        /// <param name="deploymentLogsUri"> Url to access repository action logs. </param>
        /// <param name="serializedAdditionalRawData"> Keeps track of any properties unknown to the library. </param>
        internal SourceControlDeployment(string deploymentId, SourceControlDeploymentState? deploymentState, SourceControlDeploymentResult? deploymentResult, DateTimeOffset? deploymentOn, Uri deploymentLogsUri, IDictionary<string, BinaryData> serializedAdditionalRawData)
        {
            DeploymentId = deploymentId;
            DeploymentState = deploymentState;
            DeploymentResult = deploymentResult;
            DeploymentOn = deploymentOn;
            DeploymentLogsUri = deploymentLogsUri;
            _serializedAdditionalRawData = serializedAdditionalRawData;
        }

        /// <summary> Deployment identifier. </summary>
        [WirePath("deploymentId")]
        public string DeploymentId { get; }
        /// <summary> Current status of the deployment. </summary>
        [WirePath("deploymentState")]
        public SourceControlDeploymentState? DeploymentState { get; }
        /// <summary> The outcome of the deployment. </summary>
        [WirePath("deploymentResult")]
        public SourceControlDeploymentResult? DeploymentResult { get; }
        /// <summary> The time when the deployment finished. </summary>
        [WirePath("deploymentTime")]
        public DateTimeOffset? DeploymentOn { get; }
        /// <summary> Url to access repository action logs. </summary>
        [WirePath("deploymentLogsUrl")]
        public Uri DeploymentLogsUri { get; }
    }
}
