// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ComponentModel;

namespace Azure.ResourceManager.SecurityInsights.Models
{
    /// <summary> The content type of a source control path. </summary>
    public readonly partial struct SourceControlContentType : IEquatable<SourceControlContentType>
    {
        private readonly string _value;

        /// <summary> Initializes a new instance of <see cref="SourceControlContentType"/>. </summary>
        /// <exception cref="ArgumentNullException"> <paramref name="value"/> is null. </exception>
        public SourceControlContentType(string value)
        {
            _value = value ?? throw new ArgumentNullException(nameof(value));
        }

        private const string AnalyticRuleValue = "AnalyticRule";
        private const string AutomationRuleValue = "AutomationRule";
        private const string HuntingQueryValue = "HuntingQuery";
        private const string ParserValue = "Parser";
        private const string PlaybookValue = "Playbook";
        private const string WorkbookValue = "Workbook";

        /// <summary> AnalyticRule. </summary>
        public static SourceControlContentType AnalyticRule { get; } = new SourceControlContentType(AnalyticRuleValue);
        /// <summary> AutomationRule. </summary>
        public static SourceControlContentType AutomationRule { get; } = new SourceControlContentType(AutomationRuleValue);
        /// <summary> HuntingQuery. </summary>
        public static SourceControlContentType HuntingQuery { get; } = new SourceControlContentType(HuntingQueryValue);
        /// <summary> Parser. </summary>
        public static SourceControlContentType Parser { get; } = new SourceControlContentType(ParserValue);
        /// <summary> Playbook. </summary>
        public static SourceControlContentType Playbook { get; } = new SourceControlContentType(PlaybookValue);
        /// <summary> Workbook. </summary>
        public static SourceControlContentType Workbook { get; } = new SourceControlContentType(WorkbookValue);
        /// <summary> Determines if two <see cref="SourceControlContentType"/> values are the same. </summary>
        public static bool operator ==(SourceControlContentType left, SourceControlContentType right) => left.Equals(right);
        /// <summary> Determines if two <see cref="SourceControlContentType"/> values are not the same. </summary>
        public static bool operator !=(SourceControlContentType left, SourceControlContentType right) => !left.Equals(right);
        /// <summary> Converts a <see cref="string"/> to a <see cref="SourceControlContentType"/>. </summary>
        public static implicit operator SourceControlContentType(string value) => new SourceControlContentType(value);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override bool Equals(object obj) => obj is SourceControlContentType other && Equals(other);
        /// <inheritdoc />
        public bool Equals(SourceControlContentType other) => string.Equals(_value, other._value, StringComparison.InvariantCultureIgnoreCase);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override int GetHashCode() => _value != null ? StringComparer.InvariantCultureIgnoreCase.GetHashCode(_value) : 0;
        /// <inheritdoc />
        public override string ToString() => _value;
    }
}
