// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;

namespace Azure.ResourceManager.SecurityInsights.Models
{
    /// <summary> Model for API authentication with session cookie. </summary>
    public partial class SessionAuthModel : CcpAuthConfig
    {
        /// <summary> Initializes a new instance of <see cref="SessionAuthModel"/>. </summary>
        /// <param name="userName"> The user name attribute key value. </param>
        /// <param name="password"> The password attribute name. </param>
        /// <exception cref="ArgumentNullException"> <paramref name="userName"/> or <paramref name="password"/> is null. </exception>
        public SessionAuthModel(IDictionary<string, string> userName, IDictionary<string, string> password)
        {
            Argument.AssertNotNull(userName, nameof(userName));
            Argument.AssertNotNull(password, nameof(password));

            UserName = userName;
            Password = password;
            QueryParameters = new ChangeTrackingDictionary<string, BinaryData>();
            Headers = new ChangeTrackingDictionary<string, string>();
            AuthType = CcpAuthType.Session;
        }

        /// <summary> Initializes a new instance of <see cref="SessionAuthModel"/>. </summary>
        /// <param name="authType"> The auth type. </param>
        /// <param name="serializedAdditionalRawData"> Keeps track of any properties unknown to the library. </param>
        /// <param name="userName"> The user name attribute key value. </param>
        /// <param name="password"> The password attribute name. </param>
        /// <param name="queryParameters"> Query parameters to session service endpoint. </param>
        /// <param name="isPostPayloadJson"> Indicating whether API key is set in HTTP POST payload. </param>
        /// <param name="headers"> HTTP request headers to session service endpoint. </param>
        /// <param name="sessionTimeoutInMinutes"> Session timeout in minutes. </param>
        /// <param name="sessionIdName"> Session id attribute name from HTTP response header. </param>
        /// <param name="sessionLoginRequestUri"> HTTP request URL to session service endpoint. </param>
        internal SessionAuthModel(CcpAuthType authType, IDictionary<string, BinaryData> serializedAdditionalRawData, IDictionary<string, string> userName, IDictionary<string, string> password, IDictionary<string, BinaryData> queryParameters, bool? isPostPayloadJson, IDictionary<string, string> headers, int? sessionTimeoutInMinutes, string sessionIdName, Uri sessionLoginRequestUri) : base(authType, serializedAdditionalRawData)
        {
            UserName = userName;
            Password = password;
            QueryParameters = queryParameters;
            IsPostPayloadJson = isPostPayloadJson;
            Headers = headers;
            SessionTimeoutInMinutes = sessionTimeoutInMinutes;
            SessionIdName = sessionIdName;
            SessionLoginRequestUri = sessionLoginRequestUri;
            AuthType = authType;
        }

        /// <summary> Initializes a new instance of <see cref="SessionAuthModel"/> for deserialization. </summary>
        internal SessionAuthModel()
        {
        }

        /// <summary> The user name attribute key value. </summary>
        [WirePath("userName")]
        public IDictionary<string, string> UserName { get; }
        /// <summary> The password attribute name. </summary>
        [WirePath("password")]
        public IDictionary<string, string> Password { get; }
        /// <summary>
        /// Query parameters to session service endpoint.
        /// <para>
        /// To assign an object to the value of this property use <see cref="BinaryData.FromObjectAsJson{T}(T, System.Text.Json.JsonSerializerOptions?)"/>.
        /// </para>
        /// <para>
        /// To assign an already formatted json string to this property use <see cref="BinaryData.FromString(string)"/>.
        /// </para>
        /// <para>
        /// Examples:
        /// <list type="bullet">
        /// <item>
        /// <term>BinaryData.FromObjectAsJson("foo")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("\"foo\"")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromObjectAsJson(new { key = "value" })</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("{\"key\": \"value\"}")</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// </list>
        /// </para>
        /// </summary>
        [WirePath("queryParameters")]
        public IDictionary<string, BinaryData> QueryParameters { get; }
        /// <summary> Indicating whether API key is set in HTTP POST payload. </summary>
        [WirePath("isPostPayloadJson")]
        public bool? IsPostPayloadJson { get; set; }
        /// <summary> HTTP request headers to session service endpoint. </summary>
        [WirePath("headers")]
        public IDictionary<string, string> Headers { get; }
        /// <summary> Session timeout in minutes. </summary>
        [WirePath("sessionTimeoutInMinutes")]
        public int? SessionTimeoutInMinutes { get; set; }
        /// <summary> Session id attribute name from HTTP response header. </summary>
        [WirePath("sessionIdName")]
        public string SessionIdName { get; set; }
        /// <summary> HTTP request URL to session service endpoint. </summary>
        [WirePath("sessionLoginRequestUri")]
        public Uri SessionLoginRequestUri { get; set; }
    }
}
