// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ComponentModel;

namespace Azure.ResourceManager.SecurityInsights.Models
{
    /// <summary> The kind of security ML analytics settings. </summary>
    internal readonly partial struct SecurityMLAnalyticsSettingsKind : IEquatable<SecurityMLAnalyticsSettingsKind>
    {
        private readonly string _value;

        /// <summary> Initializes a new instance of <see cref="SecurityMLAnalyticsSettingsKind"/>. </summary>
        /// <exception cref="ArgumentNullException"> <paramref name="value"/> is null. </exception>
        public SecurityMLAnalyticsSettingsKind(string value)
        {
            _value = value ?? throw new ArgumentNullException(nameof(value));
        }

        private const string AnomalyValue = "Anomaly";

        /// <summary> Anomaly. </summary>
        public static SecurityMLAnalyticsSettingsKind Anomaly { get; } = new SecurityMLAnalyticsSettingsKind(AnomalyValue);
        /// <summary> Determines if two <see cref="SecurityMLAnalyticsSettingsKind"/> values are the same. </summary>
        public static bool operator ==(SecurityMLAnalyticsSettingsKind left, SecurityMLAnalyticsSettingsKind right) => left.Equals(right);
        /// <summary> Determines if two <see cref="SecurityMLAnalyticsSettingsKind"/> values are not the same. </summary>
        public static bool operator !=(SecurityMLAnalyticsSettingsKind left, SecurityMLAnalyticsSettingsKind right) => !left.Equals(right);
        /// <summary> Converts a <see cref="string"/> to a <see cref="SecurityMLAnalyticsSettingsKind"/>. </summary>
        public static implicit operator SecurityMLAnalyticsSettingsKind(string value) => new SecurityMLAnalyticsSettingsKind(value);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override bool Equals(object obj) => obj is SecurityMLAnalyticsSettingsKind other && Equals(other);
        /// <inheritdoc />
        public bool Equals(SecurityMLAnalyticsSettingsKind other) => string.Equals(_value, other._value, StringComparison.InvariantCultureIgnoreCase);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override int GetHashCode() => _value != null ? StringComparer.InvariantCultureIgnoreCase.GetHashCode(_value) : 0;
        /// <inheritdoc />
        public override string ToString() => _value;
    }
}
