// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;
using Azure.Core;
using Azure.ResourceManager.Models;

namespace Azure.ResourceManager.SecurityInsights.Models
{
    /// <summary> Threat intelligence indicator entity. </summary>
    public partial class SecurityInsightsThreatIntelligenceIndicatorData : SecurityInsightsThreatIntelligenceIndicatorBaseData
    {
        /// <summary> Initializes a new instance of <see cref="SecurityInsightsThreatIntelligenceIndicatorData"/>. </summary>
        public SecurityInsightsThreatIntelligenceIndicatorData()
        {
            AdditionalData = new ChangeTrackingDictionary<string, BinaryData>();
            ThreatIntelligenceTags = new ChangeTrackingList<string>();
            IndicatorTypes = new ChangeTrackingList<string>();
            KillChainPhases = new ChangeTrackingList<ThreatIntelligenceKillChainPhase>();
            ParsedPattern = new ChangeTrackingList<ThreatIntelligenceParsedPattern>();
            ExternalReferences = new ChangeTrackingList<ThreatIntelligenceExternalReference>();
            GranularMarkings = new ChangeTrackingList<ThreatIntelligenceGranularMarkingEntity>();
            Labels = new ChangeTrackingList<string>();
            ObjectMarkingRefs = new ChangeTrackingList<string>();
            ThreatTypes = new ChangeTrackingList<string>();
            Extensions = new ChangeTrackingDictionary<string, BinaryData>();
            Kind = ThreatIntelligenceResourceInnerKind.Indicator;
        }

        /// <summary> Initializes a new instance of <see cref="SecurityInsightsThreatIntelligenceIndicatorData"/>. </summary>
        /// <param name="id"> The id. </param>
        /// <param name="name"> The name. </param>
        /// <param name="resourceType"> The resourceType. </param>
        /// <param name="systemData"> The systemData. </param>
        /// <param name="kind"> The kind of the entity. </param>
        /// <param name="etag"> Etag of the azure resource. </param>
        /// <param name="serializedAdditionalRawData"> Keeps track of any properties unknown to the library. </param>
        /// <param name="additionalData"> A bag of custom fields that should be part of the entity and will be presented to the user. </param>
        /// <param name="friendlyName"> The graph item display name which is a short humanly readable description of the graph item instance. This property is optional and might be system generated. </param>
        /// <param name="threatIntelligenceTags"> List of tags. </param>
        /// <param name="lastUpdatedOn"> Last updated time in UTC. </param>
        /// <param name="source"> Source of a threat intelligence entity. </param>
        /// <param name="displayName"> Display name of a threat intelligence entity. </param>
        /// <param name="description"> Description of a threat intelligence entity. </param>
        /// <param name="indicatorTypes"> Indicator types of threat intelligence entities. </param>
        /// <param name="pattern"> Pattern of a threat intelligence entity. </param>
        /// <param name="patternType"> Pattern type of a threat intelligence entity. </param>
        /// <param name="patternVersion"> Pattern version of a threat intelligence entity. </param>
        /// <param name="killChainPhases"> Kill chain phases. </param>
        /// <param name="parsedPattern"> Parsed patterns. </param>
        /// <param name="externalId"> External ID of threat intelligence entity. </param>
        /// <param name="createdByRef"> Created by reference of threat intelligence entity. </param>
        /// <param name="isDefanged"> Is threat intelligence entity defanged. </param>
        /// <param name="externalLastUpdatedOn"> External last updated time in UTC. </param>
        /// <param name="externalReferences"> External References. </param>
        /// <param name="granularMarkings"> Granular Markings. </param>
        /// <param name="labels"> Labels  of threat intelligence entity. </param>
        /// <param name="isRevoked"> Is threat intelligence entity revoked. </param>
        /// <param name="confidence"> Confidence of threat intelligence entity. </param>
        /// <param name="objectMarkingRefs"> Threat intelligence entity object marking references. </param>
        /// <param name="language"> Language of threat intelligence entity. </param>
        /// <param name="threatTypes"> Threat types. </param>
        /// <param name="validFrom"> Valid from. </param>
        /// <param name="validUntil"> Valid until. </param>
        /// <param name="createdOn"> Created by. </param>
        /// <param name="modified"> Modified by. </param>
        /// <param name="extensions"> Extensions map. </param>
        internal SecurityInsightsThreatIntelligenceIndicatorData(ResourceIdentifier id, string name, ResourceType resourceType, SystemData systemData, ThreatIntelligenceResourceInnerKind kind, ETag? etag, IDictionary<string, BinaryData> serializedAdditionalRawData, IReadOnlyDictionary<string, BinaryData> additionalData, string friendlyName, IList<string> threatIntelligenceTags, DateTimeOffset? lastUpdatedOn, string source, string displayName, string description, IList<string> indicatorTypes, string pattern, string patternType, string patternVersion, IList<ThreatIntelligenceKillChainPhase> killChainPhases, IList<ThreatIntelligenceParsedPattern> parsedPattern, string externalId, string createdByRef, bool? isDefanged, DateTimeOffset? externalLastUpdatedOn, IList<ThreatIntelligenceExternalReference> externalReferences, IList<ThreatIntelligenceGranularMarkingEntity> granularMarkings, IList<string> labels, bool? isRevoked, int? confidence, IList<string> objectMarkingRefs, string language, IList<string> threatTypes, DateTimeOffset? validFrom, DateTimeOffset? validUntil, DateTimeOffset? createdOn, string modified, IDictionary<string, BinaryData> extensions) : base(id, name, resourceType, systemData, kind, etag, serializedAdditionalRawData)
        {
            AdditionalData = additionalData;
            FriendlyName = friendlyName;
            ThreatIntelligenceTags = threatIntelligenceTags;
            LastUpdatedOn = lastUpdatedOn;
            Source = source;
            DisplayName = displayName;
            Description = description;
            IndicatorTypes = indicatorTypes;
            Pattern = pattern;
            PatternType = patternType;
            PatternVersion = patternVersion;
            KillChainPhases = killChainPhases;
            ParsedPattern = parsedPattern;
            ExternalId = externalId;
            CreatedByRef = createdByRef;
            IsDefanged = isDefanged;
            ExternalLastUpdatedOn = externalLastUpdatedOn;
            ExternalReferences = externalReferences;
            GranularMarkings = granularMarkings;
            Labels = labels;
            IsRevoked = isRevoked;
            Confidence = confidence;
            ObjectMarkingRefs = objectMarkingRefs;
            Language = language;
            ThreatTypes = threatTypes;
            ValidFrom = validFrom;
            ValidUntil = validUntil;
            CreatedOn = createdOn;
            Modified = modified;
            Extensions = extensions;
            Kind = kind;
        }

        /// <summary>
        /// A bag of custom fields that should be part of the entity and will be presented to the user.
        /// <para>
        /// To assign an object to the value of this property use <see cref="BinaryData.FromObjectAsJson{T}(T, System.Text.Json.JsonSerializerOptions?)"/>.
        /// </para>
        /// <para>
        /// To assign an already formatted json string to this property use <see cref="BinaryData.FromString(string)"/>.
        /// </para>
        /// <para>
        /// Examples:
        /// <list type="bullet">
        /// <item>
        /// <term>BinaryData.FromObjectAsJson("foo")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("\"foo\"")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromObjectAsJson(new { key = "value" })</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("{\"key\": \"value\"}")</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// </list>
        /// </para>
        /// </summary>
        [WirePath("properties.additionalData")]
        public IReadOnlyDictionary<string, BinaryData> AdditionalData { get; }
        /// <summary> The graph item display name which is a short humanly readable description of the graph item instance. This property is optional and might be system generated. </summary>
        [WirePath("properties.friendlyName")]
        public string FriendlyName { get; }
        /// <summary> List of tags. </summary>
        [WirePath("properties.threatIntelligenceTags")]
        public IList<string> ThreatIntelligenceTags { get; }
        /// <summary> Last updated time in UTC. </summary>
        [WirePath("properties.lastUpdatedTimeUtc")]
        public DateTimeOffset? LastUpdatedOn { get; set; }
        /// <summary> Source of a threat intelligence entity. </summary>
        [WirePath("properties.source")]
        public string Source { get; set; }
        /// <summary> Display name of a threat intelligence entity. </summary>
        [WirePath("properties.displayName")]
        public string DisplayName { get; set; }
        /// <summary> Description of a threat intelligence entity. </summary>
        [WirePath("properties.description")]
        public string Description { get; set; }
        /// <summary> Indicator types of threat intelligence entities. </summary>
        [WirePath("properties.indicatorTypes")]
        public IList<string> IndicatorTypes { get; }
        /// <summary> Pattern of a threat intelligence entity. </summary>
        [WirePath("properties.pattern")]
        public string Pattern { get; set; }
        /// <summary> Pattern type of a threat intelligence entity. </summary>
        [WirePath("properties.patternType")]
        public string PatternType { get; set; }
        /// <summary> Pattern version of a threat intelligence entity. </summary>
        [WirePath("properties.patternVersion")]
        public string PatternVersion { get; set; }
        /// <summary> Kill chain phases. </summary>
        [WirePath("properties.killChainPhases")]
        public IList<ThreatIntelligenceKillChainPhase> KillChainPhases { get; }
        /// <summary> Parsed patterns. </summary>
        [WirePath("properties.parsedPattern")]
        public IList<ThreatIntelligenceParsedPattern> ParsedPattern { get; }
        /// <summary> External ID of threat intelligence entity. </summary>
        [WirePath("properties.externalId")]
        public string ExternalId { get; set; }
        /// <summary> Created by reference of threat intelligence entity. </summary>
        [WirePath("properties.createdByRef")]
        public string CreatedByRef { get; set; }
        /// <summary> Is threat intelligence entity defanged. </summary>
        [WirePath("properties.defanged")]
        public bool? IsDefanged { get; set; }
        /// <summary> External last updated time in UTC. </summary>
        [WirePath("properties.externalLastUpdatedTimeUtc")]
        public DateTimeOffset? ExternalLastUpdatedOn { get; set; }
        /// <summary> External References. </summary>
        [WirePath("properties.externalReferences")]
        public IList<ThreatIntelligenceExternalReference> ExternalReferences { get; }
        /// <summary> Granular Markings. </summary>
        [WirePath("properties.granularMarkings")]
        public IList<ThreatIntelligenceGranularMarkingEntity> GranularMarkings { get; }
        /// <summary> Labels  of threat intelligence entity. </summary>
        [WirePath("properties.labels")]
        public IList<string> Labels { get; }
        /// <summary> Is threat intelligence entity revoked. </summary>
        [WirePath("properties.revoked")]
        public bool? IsRevoked { get; set; }
        /// <summary> Confidence of threat intelligence entity. </summary>
        [WirePath("properties.confidence")]
        public int? Confidence { get; set; }
        /// <summary> Threat intelligence entity object marking references. </summary>
        [WirePath("properties.objectMarkingRefs")]
        public IList<string> ObjectMarkingRefs { get; }
        /// <summary> Language of threat intelligence entity. </summary>
        [WirePath("properties.language")]
        public string Language { get; set; }
        /// <summary> Threat types. </summary>
        [WirePath("properties.threatTypes")]
        public IList<string> ThreatTypes { get; }
        /// <summary> Valid from. </summary>
        [WirePath("properties.validFrom")]
        public DateTimeOffset? ValidFrom { get; set; }
        /// <summary> Valid until. </summary>
        [WirePath("properties.validUntil")]
        public DateTimeOffset? ValidUntil { get; set; }
        /// <summary> Created by. </summary>
        [WirePath("properties.created")]
        public DateTimeOffset? CreatedOn { get; set; }
        /// <summary> Modified by. </summary>
        [WirePath("properties.modified")]
        public string Modified { get; set; }
        /// <summary>
        /// Extensions map
        /// <para>
        /// To assign an object to the value of this property use <see cref="BinaryData.FromObjectAsJson{T}(T, System.Text.Json.JsonSerializerOptions?)"/>.
        /// </para>
        /// <para>
        /// To assign an already formatted json string to this property use <see cref="BinaryData.FromString(string)"/>.
        /// </para>
        /// <para>
        /// Examples:
        /// <list type="bullet">
        /// <item>
        /// <term>BinaryData.FromObjectAsJson("foo")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("\"foo\"")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromObjectAsJson(new { key = "value" })</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("{\"key\": \"value\"}")</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// </list>
        /// </para>
        /// </summary>
        [WirePath("properties.extensions")]
        public IDictionary<string, BinaryData> Extensions { get; }
    }
}
