// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;

namespace Azure.ResourceManager.SecurityInsights.Models
{
    /// <summary> ThreatIntelligence property bag. </summary>
    public partial class SecurityInsightsThreatIntelligence
    {
        /// <summary>
        /// Keeps track of any properties unknown to the library.
        /// <para>
        /// To assign an object to the value of this property use <see cref="BinaryData.FromObjectAsJson{T}(T, System.Text.Json.JsonSerializerOptions?)"/>.
        /// </para>
        /// <para>
        /// To assign an already formatted json string to this property use <see cref="BinaryData.FromString(string)"/>.
        /// </para>
        /// <para>
        /// Examples:
        /// <list type="bullet">
        /// <item>
        /// <term>BinaryData.FromObjectAsJson("foo")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("\"foo\"")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromObjectAsJson(new { key = "value" })</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("{\"key\": \"value\"}")</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// </list>
        /// </para>
        /// </summary>
        private IDictionary<string, BinaryData> _serializedAdditionalRawData;

        /// <summary> Initializes a new instance of <see cref="SecurityInsightsThreatIntelligence"/>. </summary>
        internal SecurityInsightsThreatIntelligence()
        {
        }

        /// <summary> Initializes a new instance of <see cref="SecurityInsightsThreatIntelligence"/>. </summary>
        /// <param name="confidence"> Confidence (must be between 0 and 1). </param>
        /// <param name="providerName"> Name of the provider from whom this Threat Intelligence information was received. </param>
        /// <param name="reportLink"> Report link. </param>
        /// <param name="threatDescription"> Threat description (free text). </param>
        /// <param name="threatName"> Threat name (e.g. "Jedobot malware"). </param>
        /// <param name="threatType"> Threat type (e.g. "Botnet"). </param>
        /// <param name="serializedAdditionalRawData"> Keeps track of any properties unknown to the library. </param>
        internal SecurityInsightsThreatIntelligence(double? confidence, string providerName, string reportLink, string threatDescription, string threatName, string threatType, IDictionary<string, BinaryData> serializedAdditionalRawData)
        {
            Confidence = confidence;
            ProviderName = providerName;
            ReportLink = reportLink;
            ThreatDescription = threatDescription;
            ThreatName = threatName;
            ThreatType = threatType;
            _serializedAdditionalRawData = serializedAdditionalRawData;
        }

        /// <summary> Confidence (must be between 0 and 1). </summary>
        [WirePath("confidence")]
        public double? Confidence { get; }
        /// <summary> Name of the provider from whom this Threat Intelligence information was received. </summary>
        [WirePath("providerName")]
        public string ProviderName { get; }
        /// <summary> Report link. </summary>
        [WirePath("reportLink")]
        public string ReportLink { get; }
        /// <summary> Threat description (free text). </summary>
        [WirePath("threatDescription")]
        public string ThreatDescription { get; }
        /// <summary> Threat name (e.g. "Jedobot malware"). </summary>
        [WirePath("threatName")]
        public string ThreatName { get; }
        /// <summary> Threat type (e.g. "Botnet"). </summary>
        [WirePath("threatType")]
        public string ThreatType { get; }
    }
}
