// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ComponentModel;

namespace Azure.ResourceManager.SecurityInsights.Models
{
    /// <summary> Type of support for content item. </summary>
    public readonly partial struct SecurityInsightsSupportTier : IEquatable<SecurityInsightsSupportTier>
    {
        private readonly string _value;

        /// <summary> Initializes a new instance of <see cref="SecurityInsightsSupportTier"/>. </summary>
        /// <exception cref="ArgumentNullException"> <paramref name="value"/> is null. </exception>
        public SecurityInsightsSupportTier(string value)
        {
            _value = value ?? throw new ArgumentNullException(nameof(value));
        }

        private const string MicrosoftValue = "Microsoft";
        private const string PartnerValue = "Partner";
        private const string CommunityValue = "Community";

        /// <summary> Microsoft. </summary>
        public static SecurityInsightsSupportTier Microsoft { get; } = new SecurityInsightsSupportTier(MicrosoftValue);
        /// <summary> Partner. </summary>
        public static SecurityInsightsSupportTier Partner { get; } = new SecurityInsightsSupportTier(PartnerValue);
        /// <summary> Community. </summary>
        public static SecurityInsightsSupportTier Community { get; } = new SecurityInsightsSupportTier(CommunityValue);
        /// <summary> Determines if two <see cref="SecurityInsightsSupportTier"/> values are the same. </summary>
        public static bool operator ==(SecurityInsightsSupportTier left, SecurityInsightsSupportTier right) => left.Equals(right);
        /// <summary> Determines if two <see cref="SecurityInsightsSupportTier"/> values are not the same. </summary>
        public static bool operator !=(SecurityInsightsSupportTier left, SecurityInsightsSupportTier right) => !left.Equals(right);
        /// <summary> Converts a <see cref="string"/> to a <see cref="SecurityInsightsSupportTier"/>. </summary>
        public static implicit operator SecurityInsightsSupportTier(string value) => new SecurityInsightsSupportTier(value);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override bool Equals(object obj) => obj is SecurityInsightsSupportTier other && Equals(other);
        /// <inheritdoc />
        public bool Equals(SecurityInsightsSupportTier other) => string.Equals(_value, other._value, StringComparison.InvariantCultureIgnoreCase);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override int GetHashCode() => _value != null ? StringComparer.InvariantCultureIgnoreCase.GetHashCode(_value) : 0;
        /// <inheritdoc />
        public override string ToString() => _value;
    }
}
