// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ComponentModel;

namespace Azure.ResourceManager.SecurityInsights.Models
{
    /// <summary> Source type of the content. </summary>
    public readonly partial struct SecurityInsightsSourceKind : IEquatable<SecurityInsightsSourceKind>
    {
        private readonly string _value;

        /// <summary> Initializes a new instance of <see cref="SecurityInsightsSourceKind"/>. </summary>
        /// <exception cref="ArgumentNullException"> <paramref name="value"/> is null. </exception>
        public SecurityInsightsSourceKind(string value)
        {
            _value = value ?? throw new ArgumentNullException(nameof(value));
        }

        private const string LocalWorkspaceValue = "LocalWorkspace";
        private const string CommunityValue = "Community";
        private const string SolutionValue = "Solution";
        private const string SourceRepositoryValue = "SourceRepository";

        /// <summary> LocalWorkspace. </summary>
        public static SecurityInsightsSourceKind LocalWorkspace { get; } = new SecurityInsightsSourceKind(LocalWorkspaceValue);
        /// <summary> Community. </summary>
        public static SecurityInsightsSourceKind Community { get; } = new SecurityInsightsSourceKind(CommunityValue);
        /// <summary> Solution. </summary>
        public static SecurityInsightsSourceKind Solution { get; } = new SecurityInsightsSourceKind(SolutionValue);
        /// <summary> SourceRepository. </summary>
        public static SecurityInsightsSourceKind SourceRepository { get; } = new SecurityInsightsSourceKind(SourceRepositoryValue);
        /// <summary> Determines if two <see cref="SecurityInsightsSourceKind"/> values are the same. </summary>
        public static bool operator ==(SecurityInsightsSourceKind left, SecurityInsightsSourceKind right) => left.Equals(right);
        /// <summary> Determines if two <see cref="SecurityInsightsSourceKind"/> values are not the same. </summary>
        public static bool operator !=(SecurityInsightsSourceKind left, SecurityInsightsSourceKind right) => !left.Equals(right);
        /// <summary> Converts a <see cref="string"/> to a <see cref="SecurityInsightsSourceKind"/>. </summary>
        public static implicit operator SecurityInsightsSourceKind(string value) => new SecurityInsightsSourceKind(value);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override bool Equals(object obj) => obj is SecurityInsightsSourceKind other && Equals(other);
        /// <inheritdoc />
        public bool Equals(SecurityInsightsSourceKind other) => string.Equals(_value, other._value, StringComparison.InvariantCultureIgnoreCase);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override int GetHashCode() => _value != null ? StringComparer.InvariantCultureIgnoreCase.GetHashCode(_value) : 0;
        /// <inheritdoc />
        public override string ToString() => _value;
    }
}
