// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ComponentModel;

namespace Azure.ResourceManager.SecurityInsights.Models
{
    /// <summary> the hive that holds the registry key. </summary>
    public readonly partial struct SecurityInsightsRegistryHive : IEquatable<SecurityInsightsRegistryHive>
    {
        private readonly string _value;

        /// <summary> Initializes a new instance of <see cref="SecurityInsightsRegistryHive"/>. </summary>
        /// <exception cref="ArgumentNullException"> <paramref name="value"/> is null. </exception>
        public SecurityInsightsRegistryHive(string value)
        {
            _value = value ?? throw new ArgumentNullException(nameof(value));
        }

        private const string HkeyLocalMachineValue = "HKEY_LOCAL_MACHINE";
        private const string HkeyClassesRootValue = "HKEY_CLASSES_ROOT";
        private const string HkeyCurrentConfigValue = "HKEY_CURRENT_CONFIG";
        private const string HkeyUsersValue = "HKEY_USERS";
        private const string HkeyCurrentUserLocalSettingsValue = "HKEY_CURRENT_USER_LOCAL_SETTINGS";
        private const string HkeyPerformanceDataValue = "HKEY_PERFORMANCE_DATA";
        private const string HkeyPerformanceNlstextValue = "HKEY_PERFORMANCE_NLSTEXT";
        private const string HkeyPerformanceTextValue = "HKEY_PERFORMANCE_TEXT";
        private const string HkeyAValue = "HKEY_A";
        private const string HkeyCurrentUserValue = "HKEY_CURRENT_USER";

        /// <summary> HKEY_LOCAL_MACHINE. </summary>
        public static SecurityInsightsRegistryHive HkeyLocalMachine { get; } = new SecurityInsightsRegistryHive(HkeyLocalMachineValue);
        /// <summary> HKEY_CLASSES_ROOT. </summary>
        public static SecurityInsightsRegistryHive HkeyClassesRoot { get; } = new SecurityInsightsRegistryHive(HkeyClassesRootValue);
        /// <summary> HKEY_CURRENT_CONFIG. </summary>
        public static SecurityInsightsRegistryHive HkeyCurrentConfig { get; } = new SecurityInsightsRegistryHive(HkeyCurrentConfigValue);
        /// <summary> HKEY_USERS. </summary>
        public static SecurityInsightsRegistryHive HkeyUsers { get; } = new SecurityInsightsRegistryHive(HkeyUsersValue);
        /// <summary> HKEY_CURRENT_USER_LOCAL_SETTINGS. </summary>
        public static SecurityInsightsRegistryHive HkeyCurrentUserLocalSettings { get; } = new SecurityInsightsRegistryHive(HkeyCurrentUserLocalSettingsValue);
        /// <summary> HKEY_PERFORMANCE_DATA. </summary>
        public static SecurityInsightsRegistryHive HkeyPerformanceData { get; } = new SecurityInsightsRegistryHive(HkeyPerformanceDataValue);
        /// <summary> HKEY_PERFORMANCE_NLSTEXT. </summary>
        public static SecurityInsightsRegistryHive HkeyPerformanceNlstext { get; } = new SecurityInsightsRegistryHive(HkeyPerformanceNlstextValue);
        /// <summary> HKEY_PERFORMANCE_TEXT. </summary>
        public static SecurityInsightsRegistryHive HkeyPerformanceText { get; } = new SecurityInsightsRegistryHive(HkeyPerformanceTextValue);
        /// <summary> HKEY_A. </summary>
        public static SecurityInsightsRegistryHive HkeyA { get; } = new SecurityInsightsRegistryHive(HkeyAValue);
        /// <summary> HKEY_CURRENT_USER. </summary>
        public static SecurityInsightsRegistryHive HkeyCurrentUser { get; } = new SecurityInsightsRegistryHive(HkeyCurrentUserValue);
        /// <summary> Determines if two <see cref="SecurityInsightsRegistryHive"/> values are the same. </summary>
        public static bool operator ==(SecurityInsightsRegistryHive left, SecurityInsightsRegistryHive right) => left.Equals(right);
        /// <summary> Determines if two <see cref="SecurityInsightsRegistryHive"/> values are not the same. </summary>
        public static bool operator !=(SecurityInsightsRegistryHive left, SecurityInsightsRegistryHive right) => !left.Equals(right);
        /// <summary> Converts a <see cref="string"/> to a <see cref="SecurityInsightsRegistryHive"/>. </summary>
        public static implicit operator SecurityInsightsRegistryHive(string value) => new SecurityInsightsRegistryHive(value);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override bool Equals(object obj) => obj is SecurityInsightsRegistryHive other && Equals(other);
        /// <inheritdoc />
        public bool Equals(SecurityInsightsRegistryHive other) => string.Equals(_value, other._value, StringComparison.InvariantCultureIgnoreCase);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override int GetHashCode() => _value != null ? StringComparer.InvariantCultureIgnoreCase.GetHashCode(_value) : 0;
        /// <inheritdoc />
        public override string ToString() => _value;
    }
}
