// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;

namespace Azure.ResourceManager.SecurityInsights.Models
{
    internal static partial class SecurityInsightsProcessElevationTokenExtensions
    {
        public static string ToSerialString(this SecurityInsightsProcessElevationToken value) => value switch
        {
            SecurityInsightsProcessElevationToken.Default => "Default",
            SecurityInsightsProcessElevationToken.Full => "Full",
            SecurityInsightsProcessElevationToken.Limited => "Limited",
            _ => throw new ArgumentOutOfRangeException(nameof(value), value, "Unknown SecurityInsightsProcessElevationToken value.")
        };

        public static SecurityInsightsProcessElevationToken ToSecurityInsightsProcessElevationToken(this string value)
        {
            if (StringComparer.OrdinalIgnoreCase.Equals(value, "Default")) return SecurityInsightsProcessElevationToken.Default;
            if (StringComparer.OrdinalIgnoreCase.Equals(value, "Full")) return SecurityInsightsProcessElevationToken.Full;
            if (StringComparer.OrdinalIgnoreCase.Equals(value, "Limited")) return SecurityInsightsProcessElevationToken.Limited;
            throw new ArgumentOutOfRangeException(nameof(value), value, "Unknown SecurityInsightsProcessElevationToken value.");
        }
    }
}
