// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;

namespace Azure.ResourceManager.SecurityInsights.Models
{
    /// <summary> Support information for the content item. </summary>
    public partial class SecurityInsightsMetadataSupport
    {
        /// <summary>
        /// Keeps track of any properties unknown to the library.
        /// <para>
        /// To assign an object to the value of this property use <see cref="BinaryData.FromObjectAsJson{T}(T, System.Text.Json.JsonSerializerOptions?)"/>.
        /// </para>
        /// <para>
        /// To assign an already formatted json string to this property use <see cref="BinaryData.FromString(string)"/>.
        /// </para>
        /// <para>
        /// Examples:
        /// <list type="bullet">
        /// <item>
        /// <term>BinaryData.FromObjectAsJson("foo")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("\"foo\"")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromObjectAsJson(new { key = "value" })</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("{\"key\": \"value\"}")</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// </list>
        /// </para>
        /// </summary>
        private IDictionary<string, BinaryData> _serializedAdditionalRawData;

        /// <summary> Initializes a new instance of <see cref="SecurityInsightsMetadataSupport"/>. </summary>
        /// <param name="tier"> Type of support for content item. </param>
        public SecurityInsightsMetadataSupport(SecurityInsightsSupportTier tier)
        {
            Tier = tier;
        }

        /// <summary> Initializes a new instance of <see cref="SecurityInsightsMetadataSupport"/>. </summary>
        /// <param name="tier"> Type of support for content item. </param>
        /// <param name="name"> Name of the support contact. Company or person. </param>
        /// <param name="email"> Email of support contact. </param>
        /// <param name="link"> Link for support help, like to support page to open a ticket etc. </param>
        /// <param name="serializedAdditionalRawData"> Keeps track of any properties unknown to the library. </param>
        internal SecurityInsightsMetadataSupport(SecurityInsightsSupportTier tier, string name, string email, string link, IDictionary<string, BinaryData> serializedAdditionalRawData)
        {
            Tier = tier;
            Name = name;
            Email = email;
            Link = link;
            _serializedAdditionalRawData = serializedAdditionalRawData;
        }

        /// <summary> Initializes a new instance of <see cref="SecurityInsightsMetadataSupport"/> for deserialization. </summary>
        internal SecurityInsightsMetadataSupport()
        {
        }

        /// <summary> Type of support for content item. </summary>
        [WirePath("tier")]
        public SecurityInsightsSupportTier Tier { get; set; }
        /// <summary> Name of the support contact. Company or person. </summary>
        [WirePath("name")]
        public string Name { get; set; }
        /// <summary> Email of support contact. </summary>
        [WirePath("email")]
        public string Email { get; set; }
        /// <summary> Link for support help, like to support page to open a ticket etc. </summary>
        [WirePath("link")]
        public string Link { get; set; }
    }
}
