// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;

namespace Azure.ResourceManager.SecurityInsights.Models
{
    /// <summary> The original source of the content item, where it comes from. </summary>
    public partial class SecurityInsightsMetadataSource
    {
        /// <summary>
        /// Keeps track of any properties unknown to the library.
        /// <para>
        /// To assign an object to the value of this property use <see cref="BinaryData.FromObjectAsJson{T}(T, System.Text.Json.JsonSerializerOptions?)"/>.
        /// </para>
        /// <para>
        /// To assign an already formatted json string to this property use <see cref="BinaryData.FromString(string)"/>.
        /// </para>
        /// <para>
        /// Examples:
        /// <list type="bullet">
        /// <item>
        /// <term>BinaryData.FromObjectAsJson("foo")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("\"foo\"")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromObjectAsJson(new { key = "value" })</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("{\"key\": \"value\"}")</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// </list>
        /// </para>
        /// </summary>
        private IDictionary<string, BinaryData> _serializedAdditionalRawData;

        /// <summary> Initializes a new instance of <see cref="SecurityInsightsMetadataSource"/>. </summary>
        /// <param name="kind"> Source type of the content. </param>
        public SecurityInsightsMetadataSource(SecurityInsightsSourceKind kind)
        {
            Kind = kind;
        }

        /// <summary> Initializes a new instance of <see cref="SecurityInsightsMetadataSource"/>. </summary>
        /// <param name="kind"> Source type of the content. </param>
        /// <param name="name"> Name of the content source.  The repo name, solution name, LA workspace name etc. </param>
        /// <param name="sourceId"> ID of the content source.  The solution ID, workspace ID, etc. </param>
        /// <param name="serializedAdditionalRawData"> Keeps track of any properties unknown to the library. </param>
        internal SecurityInsightsMetadataSource(SecurityInsightsSourceKind kind, string name, string sourceId, IDictionary<string, BinaryData> serializedAdditionalRawData)
        {
            Kind = kind;
            Name = name;
            SourceId = sourceId;
            _serializedAdditionalRawData = serializedAdditionalRawData;
        }

        /// <summary> Initializes a new instance of <see cref="SecurityInsightsMetadataSource"/> for deserialization. </summary>
        internal SecurityInsightsMetadataSource()
        {
        }

        /// <summary> Source type of the content. </summary>
        [WirePath("kind")]
        public SecurityInsightsSourceKind Kind { get; set; }
        /// <summary> Name of the content source.  The repo name, solution name, LA workspace name etc. </summary>
        [WirePath("name")]
        public string Name { get; set; }
        /// <summary> ID of the content source.  The solution ID, workspace ID, etc. </summary>
        [WirePath("sourceId")]
        public string SourceId { get; set; }
    }
}
