// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ComponentModel;

namespace Azure.ResourceManager.SecurityInsights.Models
{
    /// <summary> The boolean value the metadata is for. </summary>
    public readonly partial struct SecurityInsightsMetadataFlag : IEquatable<SecurityInsightsMetadataFlag>
    {
        private readonly string _value;

        /// <summary> Initializes a new instance of <see cref="SecurityInsightsMetadataFlag"/>. </summary>
        /// <exception cref="ArgumentNullException"> <paramref name="value"/> is null. </exception>
        public SecurityInsightsMetadataFlag(string value)
        {
            _value = value ?? throw new ArgumentNullException(nameof(value));
        }

        private const string TrueValue = "true";
        private const string FalseValue = "false";

        /// <summary> true. </summary>
        public static SecurityInsightsMetadataFlag True { get; } = new SecurityInsightsMetadataFlag(TrueValue);
        /// <summary> false. </summary>
        public static SecurityInsightsMetadataFlag False { get; } = new SecurityInsightsMetadataFlag(FalseValue);
        /// <summary> Determines if two <see cref="SecurityInsightsMetadataFlag"/> values are the same. </summary>
        public static bool operator ==(SecurityInsightsMetadataFlag left, SecurityInsightsMetadataFlag right) => left.Equals(right);
        /// <summary> Determines if two <see cref="SecurityInsightsMetadataFlag"/> values are not the same. </summary>
        public static bool operator !=(SecurityInsightsMetadataFlag left, SecurityInsightsMetadataFlag right) => !left.Equals(right);
        /// <summary> Converts a <see cref="string"/> to a <see cref="SecurityInsightsMetadataFlag"/>. </summary>
        public static implicit operator SecurityInsightsMetadataFlag(string value) => new SecurityInsightsMetadataFlag(value);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override bool Equals(object obj) => obj is SecurityInsightsMetadataFlag other && Equals(other);
        /// <inheritdoc />
        public bool Equals(SecurityInsightsMetadataFlag other) => string.Equals(_value, other._value, StringComparison.InvariantCultureIgnoreCase);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override int GetHashCode() => _value != null ? StringComparer.InvariantCultureIgnoreCase.GetHashCode(_value) : 0;
        /// <inheritdoc />
        public override string ToString() => _value;
    }
}
