// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;
using Azure.Core;
using Azure.ResourceManager.Models;

namespace Azure.ResourceManager.SecurityInsights.Models
{
    /// <summary> Represents a malware entity. </summary>
    public partial class SecurityInsightsMalwareEntity : SecurityInsightsEntity
    {
        /// <summary> Initializes a new instance of <see cref="SecurityInsightsMalwareEntity"/>. </summary>
        public SecurityInsightsMalwareEntity()
        {
            AdditionalData = new ChangeTrackingDictionary<string, BinaryData>();
            FileEntityIds = new ChangeTrackingList<string>();
            ProcessEntityIds = new ChangeTrackingList<string>();
            Kind = SecurityInsightsEntityKind.Malware;
        }

        /// <summary> Initializes a new instance of <see cref="SecurityInsightsMalwareEntity"/>. </summary>
        /// <param name="id"> The id. </param>
        /// <param name="name"> The name. </param>
        /// <param name="resourceType"> The resourceType. </param>
        /// <param name="systemData"> The systemData. </param>
        /// <param name="kind"> The kind of the entity. </param>
        /// <param name="serializedAdditionalRawData"> Keeps track of any properties unknown to the library. </param>
        /// <param name="additionalData"> A bag of custom fields that should be part of the entity and will be presented to the user. </param>
        /// <param name="friendlyName"> The graph item display name which is a short humanly readable description of the graph item instance. This property is optional and might be system generated. </param>
        /// <param name="category"> The malware category by the vendor, e.g. Trojan. </param>
        /// <param name="fileEntityIds"> List of linked file entity identifiers on which the malware was found. </param>
        /// <param name="malwareName"> The malware name by the vendor, e.g. Win32/Toga!rfn. </param>
        /// <param name="processEntityIds"> List of linked process entity identifiers on which the malware was found. </param>
        internal SecurityInsightsMalwareEntity(ResourceIdentifier id, string name, ResourceType resourceType, SystemData systemData, SecurityInsightsEntityKind kind, IDictionary<string, BinaryData> serializedAdditionalRawData, IReadOnlyDictionary<string, BinaryData> additionalData, string friendlyName, string category, IReadOnlyList<string> fileEntityIds, string malwareName, IReadOnlyList<string> processEntityIds) : base(id, name, resourceType, systemData, kind, serializedAdditionalRawData)
        {
            AdditionalData = additionalData;
            FriendlyName = friendlyName;
            Category = category;
            FileEntityIds = fileEntityIds;
            MalwareName = malwareName;
            ProcessEntityIds = processEntityIds;
            Kind = kind;
        }

        /// <summary>
        /// A bag of custom fields that should be part of the entity and will be presented to the user.
        /// <para>
        /// To assign an object to the value of this property use <see cref="BinaryData.FromObjectAsJson{T}(T, System.Text.Json.JsonSerializerOptions?)"/>.
        /// </para>
        /// <para>
        /// To assign an already formatted json string to this property use <see cref="BinaryData.FromString(string)"/>.
        /// </para>
        /// <para>
        /// Examples:
        /// <list type="bullet">
        /// <item>
        /// <term>BinaryData.FromObjectAsJson("foo")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("\"foo\"")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromObjectAsJson(new { key = "value" })</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("{\"key\": \"value\"}")</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// </list>
        /// </para>
        /// </summary>
        [WirePath("properties.additionalData")]
        public IReadOnlyDictionary<string, BinaryData> AdditionalData { get; }
        /// <summary> The graph item display name which is a short humanly readable description of the graph item instance. This property is optional and might be system generated. </summary>
        [WirePath("properties.friendlyName")]
        public string FriendlyName { get; }
        /// <summary> The malware category by the vendor, e.g. Trojan. </summary>
        [WirePath("properties.category")]
        public string Category { get; }
        /// <summary> List of linked file entity identifiers on which the malware was found. </summary>
        [WirePath("properties.fileEntityIds")]
        public IReadOnlyList<string> FileEntityIds { get; }
        /// <summary> The malware name by the vendor, e.g. Win32/Toga!rfn. </summary>
        [WirePath("properties.malwareName")]
        public string MalwareName { get; }
        /// <summary> List of linked process entity identifiers on which the malware was found. </summary>
        [WirePath("properties.processEntityIds")]
        public IReadOnlyList<string> ProcessEntityIds { get; }
    }
}
