// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;

namespace Azure.ResourceManager.SecurityInsights.Models
{
    internal static partial class SecurityInsightsMailMessageDeliveryActionExtensions
    {
        public static string ToSerialString(this SecurityInsightsMailMessageDeliveryAction value) => value switch
        {
            SecurityInsightsMailMessageDeliveryAction.Unknown => "Unknown",
            SecurityInsightsMailMessageDeliveryAction.DeliveredAsSpam => "DeliveredAsSpam",
            SecurityInsightsMailMessageDeliveryAction.Delivered => "Delivered",
            SecurityInsightsMailMessageDeliveryAction.Blocked => "Blocked",
            SecurityInsightsMailMessageDeliveryAction.Replaced => "Replaced",
            _ => throw new ArgumentOutOfRangeException(nameof(value), value, "Unknown SecurityInsightsMailMessageDeliveryAction value.")
        };

        public static SecurityInsightsMailMessageDeliveryAction ToSecurityInsightsMailMessageDeliveryAction(this string value)
        {
            if (StringComparer.OrdinalIgnoreCase.Equals(value, "Unknown")) return SecurityInsightsMailMessageDeliveryAction.Unknown;
            if (StringComparer.OrdinalIgnoreCase.Equals(value, "DeliveredAsSpam")) return SecurityInsightsMailMessageDeliveryAction.DeliveredAsSpam;
            if (StringComparer.OrdinalIgnoreCase.Equals(value, "Delivered")) return SecurityInsightsMailMessageDeliveryAction.Delivered;
            if (StringComparer.OrdinalIgnoreCase.Equals(value, "Blocked")) return SecurityInsightsMailMessageDeliveryAction.Blocked;
            if (StringComparer.OrdinalIgnoreCase.Equals(value, "Replaced")) return SecurityInsightsMailMessageDeliveryAction.Replaced;
            throw new ArgumentOutOfRangeException(nameof(value), value, "Unknown SecurityInsightsMailMessageDeliveryAction value.");
        }
    }
}
