// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;

namespace Azure.ResourceManager.SecurityInsights.Models
{
    /// <summary> Represents an incident label. </summary>
    public partial class SecurityInsightsIncidentLabel
    {
        /// <summary>
        /// Keeps track of any properties unknown to the library.
        /// <para>
        /// To assign an object to the value of this property use <see cref="BinaryData.FromObjectAsJson{T}(T, System.Text.Json.JsonSerializerOptions?)"/>.
        /// </para>
        /// <para>
        /// To assign an already formatted json string to this property use <see cref="BinaryData.FromString(string)"/>.
        /// </para>
        /// <para>
        /// Examples:
        /// <list type="bullet">
        /// <item>
        /// <term>BinaryData.FromObjectAsJson("foo")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("\"foo\"")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromObjectAsJson(new { key = "value" })</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("{\"key\": \"value\"}")</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// </list>
        /// </para>
        /// </summary>
        private IDictionary<string, BinaryData> _serializedAdditionalRawData;

        /// <summary> Initializes a new instance of <see cref="SecurityInsightsIncidentLabel"/>. </summary>
        /// <param name="labelName"> The name of the label. </param>
        /// <exception cref="ArgumentNullException"> <paramref name="labelName"/> is null. </exception>
        public SecurityInsightsIncidentLabel(string labelName)
        {
            Argument.AssertNotNull(labelName, nameof(labelName));

            LabelName = labelName;
        }

        /// <summary> Initializes a new instance of <see cref="SecurityInsightsIncidentLabel"/>. </summary>
        /// <param name="labelName"> The name of the label. </param>
        /// <param name="labelType"> The type of the label. </param>
        /// <param name="serializedAdditionalRawData"> Keeps track of any properties unknown to the library. </param>
        internal SecurityInsightsIncidentLabel(string labelName, SecurityInsightsIncidentLabelType? labelType, IDictionary<string, BinaryData> serializedAdditionalRawData)
        {
            LabelName = labelName;
            LabelType = labelType;
            _serializedAdditionalRawData = serializedAdditionalRawData;
        }

        /// <summary> Initializes a new instance of <see cref="SecurityInsightsIncidentLabel"/> for deserialization. </summary>
        internal SecurityInsightsIncidentLabel()
        {
        }

        /// <summary> The name of the label. </summary>
        [WirePath("labelName")]
        public string LabelName { get; set; }
        /// <summary> The type of the label. </summary>
        [WirePath("labelType")]
        public SecurityInsightsIncidentLabelType? LabelType { get; }
    }
}
