// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ComponentModel;

namespace Azure.ResourceManager.SecurityInsights.Models
{
    /// <summary> The reason the incident was closed. </summary>
    public readonly partial struct SecurityInsightsIncidentClassification : IEquatable<SecurityInsightsIncidentClassification>
    {
        private readonly string _value;

        /// <summary> Initializes a new instance of <see cref="SecurityInsightsIncidentClassification"/>. </summary>
        /// <exception cref="ArgumentNullException"> <paramref name="value"/> is null. </exception>
        public SecurityInsightsIncidentClassification(string value)
        {
            _value = value ?? throw new ArgumentNullException(nameof(value));
        }

        private const string UndeterminedValue = "Undetermined";
        private const string TruePositiveValue = "TruePositive";
        private const string BenignPositiveValue = "BenignPositive";
        private const string FalsePositiveValue = "FalsePositive";

        /// <summary> Incident classification was undetermined. </summary>
        public static SecurityInsightsIncidentClassification Undetermined { get; } = new SecurityInsightsIncidentClassification(UndeterminedValue);
        /// <summary> Incident was true positive. </summary>
        public static SecurityInsightsIncidentClassification TruePositive { get; } = new SecurityInsightsIncidentClassification(TruePositiveValue);
        /// <summary> Incident was benign positive. </summary>
        public static SecurityInsightsIncidentClassification BenignPositive { get; } = new SecurityInsightsIncidentClassification(BenignPositiveValue);
        /// <summary> Incident was false positive. </summary>
        public static SecurityInsightsIncidentClassification FalsePositive { get; } = new SecurityInsightsIncidentClassification(FalsePositiveValue);
        /// <summary> Determines if two <see cref="SecurityInsightsIncidentClassification"/> values are the same. </summary>
        public static bool operator ==(SecurityInsightsIncidentClassification left, SecurityInsightsIncidentClassification right) => left.Equals(right);
        /// <summary> Determines if two <see cref="SecurityInsightsIncidentClassification"/> values are not the same. </summary>
        public static bool operator !=(SecurityInsightsIncidentClassification left, SecurityInsightsIncidentClassification right) => !left.Equals(right);
        /// <summary> Converts a <see cref="string"/> to a <see cref="SecurityInsightsIncidentClassification"/>. </summary>
        public static implicit operator SecurityInsightsIncidentClassification(string value) => new SecurityInsightsIncidentClassification(value);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override bool Equals(object obj) => obj is SecurityInsightsIncidentClassification other && Equals(other);
        /// <inheritdoc />
        public bool Equals(SecurityInsightsIncidentClassification other) => string.Equals(_value, other._value, StringComparison.InvariantCultureIgnoreCase);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override int GetHashCode() => _value != null ? StringComparer.InvariantCultureIgnoreCase.GetHashCode(_value) : 0;
        /// <inheritdoc />
        public override string ToString() => _value;
    }
}
