// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;

namespace Azure.ResourceManager.SecurityInsights.Models
{
    /// <summary> The SecurityInsightsIncidentActionConfiguration. </summary>
    public partial class SecurityInsightsIncidentActionConfiguration
    {
        /// <summary>
        /// Keeps track of any properties unknown to the library.
        /// <para>
        /// To assign an object to the value of this property use <see cref="BinaryData.FromObjectAsJson{T}(T, System.Text.Json.JsonSerializerOptions?)"/>.
        /// </para>
        /// <para>
        /// To assign an already formatted json string to this property use <see cref="BinaryData.FromString(string)"/>.
        /// </para>
        /// <para>
        /// Examples:
        /// <list type="bullet">
        /// <item>
        /// <term>BinaryData.FromObjectAsJson("foo")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("\"foo\"")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromObjectAsJson(new { key = "value" })</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("{\"key\": \"value\"}")</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// </list>
        /// </para>
        /// </summary>
        private IDictionary<string, BinaryData> _serializedAdditionalRawData;

        /// <summary> Initializes a new instance of <see cref="SecurityInsightsIncidentActionConfiguration"/>. </summary>
        public SecurityInsightsIncidentActionConfiguration()
        {
            Labels = new ChangeTrackingList<SecurityInsightsIncidentLabel>();
        }

        /// <summary> Initializes a new instance of <see cref="SecurityInsightsIncidentActionConfiguration"/>. </summary>
        /// <param name="severity"> The severity of the incident. </param>
        /// <param name="status"> The status of the incident. </param>
        /// <param name="classification"> The reason the incident was closed. </param>
        /// <param name="classificationReason"> The classification reason the incident was closed with. </param>
        /// <param name="classificationComment"> Describes the reason the incident was closed. </param>
        /// <param name="owner"> Information on the user an incident is assigned to. </param>
        /// <param name="labels"> List of labels to add to the incident. </param>
        /// <param name="serializedAdditionalRawData"> Keeps track of any properties unknown to the library. </param>
        internal SecurityInsightsIncidentActionConfiguration(SecurityInsightsIncidentSeverity? severity, SecurityInsightsIncidentStatus? status, SecurityInsightsIncidentClassification? classification, SecurityInsightsIncidentClassificationReason? classificationReason, string classificationComment, SecurityInsightsIncidentOwnerInfo owner, IList<SecurityInsightsIncidentLabel> labels, IDictionary<string, BinaryData> serializedAdditionalRawData)
        {
            Severity = severity;
            Status = status;
            Classification = classification;
            ClassificationReason = classificationReason;
            ClassificationComment = classificationComment;
            Owner = owner;
            Labels = labels;
            _serializedAdditionalRawData = serializedAdditionalRawData;
        }

        /// <summary> The severity of the incident. </summary>
        [WirePath("severity")]
        public SecurityInsightsIncidentSeverity? Severity { get; set; }
        /// <summary> The status of the incident. </summary>
        [WirePath("status")]
        public SecurityInsightsIncidentStatus? Status { get; set; }
        /// <summary> The reason the incident was closed. </summary>
        [WirePath("classification")]
        public SecurityInsightsIncidentClassification? Classification { get; set; }
        /// <summary> The classification reason the incident was closed with. </summary>
        [WirePath("classificationReason")]
        public SecurityInsightsIncidentClassificationReason? ClassificationReason { get; set; }
        /// <summary> Describes the reason the incident was closed. </summary>
        [WirePath("classificationComment")]
        public string ClassificationComment { get; set; }
        /// <summary> Information on the user an incident is assigned to. </summary>
        [WirePath("owner")]
        public SecurityInsightsIncidentOwnerInfo Owner { get; set; }
        /// <summary> List of labels to add to the incident. </summary>
        [WirePath("labels")]
        public IList<SecurityInsightsIncidentLabel> Labels { get; }
    }
}
