// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;

namespace Azure.ResourceManager.SecurityInsights.Models
{
    /// <summary> The geo-location context attached to the ip entity. </summary>
    public partial class SecurityInsightsIPEntityGeoLocation
    {
        /// <summary>
        /// Keeps track of any properties unknown to the library.
        /// <para>
        /// To assign an object to the value of this property use <see cref="BinaryData.FromObjectAsJson{T}(T, System.Text.Json.JsonSerializerOptions?)"/>.
        /// </para>
        /// <para>
        /// To assign an already formatted json string to this property use <see cref="BinaryData.FromString(string)"/>.
        /// </para>
        /// <para>
        /// Examples:
        /// <list type="bullet">
        /// <item>
        /// <term>BinaryData.FromObjectAsJson("foo")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("\"foo\"")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromObjectAsJson(new { key = "value" })</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("{\"key\": \"value\"}")</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// </list>
        /// </para>
        /// </summary>
        private IDictionary<string, BinaryData> _serializedAdditionalRawData;

        /// <summary> Initializes a new instance of <see cref="SecurityInsightsIPEntityGeoLocation"/>. </summary>
        internal SecurityInsightsIPEntityGeoLocation()
        {
        }

        /// <summary> Initializes a new instance of <see cref="SecurityInsightsIPEntityGeoLocation"/>. </summary>
        /// <param name="asn"> Autonomous System Number. </param>
        /// <param name="city"> City name. </param>
        /// <param name="countryCode"> The country code according to ISO 3166 format. </param>
        /// <param name="countryName"> Country name according to ISO 3166 Alpha 2: the lowercase of the English Short Name. </param>
        /// <param name="latitude"> The latitude of the identified location, expressed as a floating point number with range of - 90 to 90. Latitude and longitude are derived from the city or postal code. </param>
        /// <param name="longitude"> The longitude of the identified location, expressed as a floating point number with range of -180 to 180. Latitude and longitude are derived from the city or postal code. </param>
        /// <param name="state"> State name. </param>
        /// <param name="serializedAdditionalRawData"> Keeps track of any properties unknown to the library. </param>
        internal SecurityInsightsIPEntityGeoLocation(int? asn, string city, string countryCode, string countryName, double? latitude, double? longitude, string state, IDictionary<string, BinaryData> serializedAdditionalRawData)
        {
            Asn = asn;
            City = city;
            CountryCode = countryCode;
            CountryName = countryName;
            Latitude = latitude;
            Longitude = longitude;
            State = state;
            _serializedAdditionalRawData = serializedAdditionalRawData;
        }

        /// <summary> Autonomous System Number. </summary>
        [WirePath("asn")]
        public int? Asn { get; }
        /// <summary> City name. </summary>
        [WirePath("city")]
        public string City { get; }
        /// <summary> The country code according to ISO 3166 format. </summary>
        [WirePath("countryCode")]
        public string CountryCode { get; }
        /// <summary> Country name according to ISO 3166 Alpha 2: the lowercase of the English Short Name. </summary>
        [WirePath("countryName")]
        public string CountryName { get; }
        /// <summary> The latitude of the identified location, expressed as a floating point number with range of - 90 to 90. Latitude and longitude are derived from the city or postal code. </summary>
        [WirePath("latitude")]
        public double? Latitude { get; }
        /// <summary> The longitude of the identified location, expressed as a floating point number with range of -180 to 180. Latitude and longitude are derived from the city or postal code. </summary>
        [WirePath("longitude")]
        public double? Longitude { get; }
        /// <summary> State name. </summary>
        [WirePath("state")]
        public string State { get; }
    }
}
