// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ClientModel.Primitives;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Text.Json;
using Azure.Core;

namespace Azure.ResourceManager.SecurityInsights.Models
{
    public partial class SecurityInsightsGroupingConfiguration : IUtf8JsonSerializable, IJsonModel<SecurityInsightsGroupingConfiguration>
    {
        void IUtf8JsonSerializable.Write(Utf8JsonWriter writer) => ((IJsonModel<SecurityInsightsGroupingConfiguration>)this).Write(writer, ModelSerializationExtensions.WireOptions);

        void IJsonModel<SecurityInsightsGroupingConfiguration>.Write(Utf8JsonWriter writer, ModelReaderWriterOptions options)
        {
            writer.WriteStartObject();
            JsonModelWriteCore(writer, options);
            writer.WriteEndObject();
        }

        /// <param name="writer"> The JSON writer. </param>
        /// <param name="options"> The client options for reading and writing models. </param>
        protected virtual void JsonModelWriteCore(Utf8JsonWriter writer, ModelReaderWriterOptions options)
        {
            var format = options.Format == "W" ? ((IPersistableModel<SecurityInsightsGroupingConfiguration>)this).GetFormatFromOptions(options) : options.Format;
            if (format != "J")
            {
                throw new FormatException($"The model {nameof(SecurityInsightsGroupingConfiguration)} does not support writing '{format}' format.");
            }

            writer.WritePropertyName("enabled"u8);
            writer.WriteBooleanValue(IsEnabled);
            writer.WritePropertyName("reopenClosedIncident"u8);
            writer.WriteBooleanValue(IsClosedIncidentReopened);
            writer.WritePropertyName("lookbackDuration"u8);
            writer.WriteStringValue(LookbackDuration, "P");
            writer.WritePropertyName("matchingMethod"u8);
            writer.WriteStringValue(MatchingMethod.ToString());
            if (Optional.IsCollectionDefined(GroupByEntities))
            {
                writer.WritePropertyName("groupByEntities"u8);
                writer.WriteStartArray();
                foreach (var item in GroupByEntities)
                {
                    writer.WriteStringValue(item.ToString());
                }
                writer.WriteEndArray();
            }
            if (Optional.IsCollectionDefined(GroupByAlertDetails))
            {
                writer.WritePropertyName("groupByAlertDetails"u8);
                writer.WriteStartArray();
                foreach (var item in GroupByAlertDetails)
                {
                    writer.WriteStringValue(item.ToString());
                }
                writer.WriteEndArray();
            }
            if (Optional.IsCollectionDefined(GroupByCustomDetails))
            {
                writer.WritePropertyName("groupByCustomDetails"u8);
                writer.WriteStartArray();
                foreach (var item in GroupByCustomDetails)
                {
                    writer.WriteStringValue(item);
                }
                writer.WriteEndArray();
            }
            if (options.Format != "W" && _serializedAdditionalRawData != null)
            {
                foreach (var item in _serializedAdditionalRawData)
                {
                    writer.WritePropertyName(item.Key);
#if NET6_0_OR_GREATER
				writer.WriteRawValue(item.Value);
#else
                    using (JsonDocument document = JsonDocument.Parse(item.Value))
                    {
                        JsonSerializer.Serialize(writer, document.RootElement);
                    }
#endif
                }
            }
        }

        SecurityInsightsGroupingConfiguration IJsonModel<SecurityInsightsGroupingConfiguration>.Create(ref Utf8JsonReader reader, ModelReaderWriterOptions options)
        {
            var format = options.Format == "W" ? ((IPersistableModel<SecurityInsightsGroupingConfiguration>)this).GetFormatFromOptions(options) : options.Format;
            if (format != "J")
            {
                throw new FormatException($"The model {nameof(SecurityInsightsGroupingConfiguration)} does not support reading '{format}' format.");
            }

            using JsonDocument document = JsonDocument.ParseValue(ref reader);
            return DeserializeSecurityInsightsGroupingConfiguration(document.RootElement, options);
        }

        internal static SecurityInsightsGroupingConfiguration DeserializeSecurityInsightsGroupingConfiguration(JsonElement element, ModelReaderWriterOptions options = null)
        {
            options ??= ModelSerializationExtensions.WireOptions;

            if (element.ValueKind == JsonValueKind.Null)
            {
                return null;
            }
            bool enabled = default;
            bool reopenClosedIncident = default;
            TimeSpan lookbackDuration = default;
            SecurityInsightsGroupingMatchingMethod matchingMethod = default;
            IList<SecurityInsightsAlertRuleEntityMappingType> groupByEntities = default;
            IList<SecurityInsightsAlertDetail> groupByAlertDetails = default;
            IList<string> groupByCustomDetails = default;
            IDictionary<string, BinaryData> serializedAdditionalRawData = default;
            Dictionary<string, BinaryData> rawDataDictionary = new Dictionary<string, BinaryData>();
            foreach (var property in element.EnumerateObject())
            {
                if (property.NameEquals("enabled"u8))
                {
                    enabled = property.Value.GetBoolean();
                    continue;
                }
                if (property.NameEquals("reopenClosedIncident"u8))
                {
                    reopenClosedIncident = property.Value.GetBoolean();
                    continue;
                }
                if (property.NameEquals("lookbackDuration"u8))
                {
                    lookbackDuration = property.Value.GetTimeSpan("P");
                    continue;
                }
                if (property.NameEquals("matchingMethod"u8))
                {
                    matchingMethod = new SecurityInsightsGroupingMatchingMethod(property.Value.GetString());
                    continue;
                }
                if (property.NameEquals("groupByEntities"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    List<SecurityInsightsAlertRuleEntityMappingType> array = new List<SecurityInsightsAlertRuleEntityMappingType>();
                    foreach (var item in property.Value.EnumerateArray())
                    {
                        array.Add(new SecurityInsightsAlertRuleEntityMappingType(item.GetString()));
                    }
                    groupByEntities = array;
                    continue;
                }
                if (property.NameEquals("groupByAlertDetails"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    List<SecurityInsightsAlertDetail> array = new List<SecurityInsightsAlertDetail>();
                    foreach (var item in property.Value.EnumerateArray())
                    {
                        array.Add(new SecurityInsightsAlertDetail(item.GetString()));
                    }
                    groupByAlertDetails = array;
                    continue;
                }
                if (property.NameEquals("groupByCustomDetails"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    List<string> array = new List<string>();
                    foreach (var item in property.Value.EnumerateArray())
                    {
                        array.Add(item.GetString());
                    }
                    groupByCustomDetails = array;
                    continue;
                }
                if (options.Format != "W")
                {
                    rawDataDictionary.Add(property.Name, BinaryData.FromString(property.Value.GetRawText()));
                }
            }
            serializedAdditionalRawData = rawDataDictionary;
            return new SecurityInsightsGroupingConfiguration(
                enabled,
                reopenClosedIncident,
                lookbackDuration,
                matchingMethod,
                groupByEntities ?? new ChangeTrackingList<SecurityInsightsAlertRuleEntityMappingType>(),
                groupByAlertDetails ?? new ChangeTrackingList<SecurityInsightsAlertDetail>(),
                groupByCustomDetails ?? new ChangeTrackingList<string>(),
                serializedAdditionalRawData);
        }

        private BinaryData SerializeBicep(ModelReaderWriterOptions options)
        {
            StringBuilder builder = new StringBuilder();
            BicepModelReaderWriterOptions bicepOptions = options as BicepModelReaderWriterOptions;
            IDictionary<string, string> propertyOverrides = null;
            bool hasObjectOverride = bicepOptions != null && bicepOptions.PropertyOverrides.TryGetValue(this, out propertyOverrides);
            bool hasPropertyOverride = false;
            string propertyOverride = null;

            builder.AppendLine("{");

            hasPropertyOverride = hasObjectOverride && propertyOverrides.TryGetValue(nameof(IsEnabled), out propertyOverride);
            if (hasPropertyOverride)
            {
                builder.Append("  enabled: ");
                builder.AppendLine(propertyOverride);
            }
            else
            {
                builder.Append("  enabled: ");
                var boolValue = IsEnabled == true ? "true" : "false";
                builder.AppendLine($"{boolValue}");
            }

            hasPropertyOverride = hasObjectOverride && propertyOverrides.TryGetValue(nameof(IsClosedIncidentReopened), out propertyOverride);
            if (hasPropertyOverride)
            {
                builder.Append("  reopenClosedIncident: ");
                builder.AppendLine(propertyOverride);
            }
            else
            {
                builder.Append("  reopenClosedIncident: ");
                var boolValue = IsClosedIncidentReopened == true ? "true" : "false";
                builder.AppendLine($"{boolValue}");
            }

            hasPropertyOverride = hasObjectOverride && propertyOverrides.TryGetValue(nameof(LookbackDuration), out propertyOverride);
            if (hasPropertyOverride)
            {
                builder.Append("  lookbackDuration: ");
                builder.AppendLine(propertyOverride);
            }
            else
            {
                builder.Append("  lookbackDuration: ");
                var formattedTimeSpan = TypeFormatters.ToString(LookbackDuration, "P");
                builder.AppendLine($"'{formattedTimeSpan}'");
            }

            hasPropertyOverride = hasObjectOverride && propertyOverrides.TryGetValue(nameof(MatchingMethod), out propertyOverride);
            if (hasPropertyOverride)
            {
                builder.Append("  matchingMethod: ");
                builder.AppendLine(propertyOverride);
            }
            else
            {
                builder.Append("  matchingMethod: ");
                builder.AppendLine($"'{MatchingMethod.ToString()}'");
            }

            hasPropertyOverride = hasObjectOverride && propertyOverrides.TryGetValue(nameof(GroupByEntities), out propertyOverride);
            if (hasPropertyOverride)
            {
                builder.Append("  groupByEntities: ");
                builder.AppendLine(propertyOverride);
            }
            else
            {
                if (Optional.IsCollectionDefined(GroupByEntities))
                {
                    if (GroupByEntities.Any())
                    {
                        builder.Append("  groupByEntities: ");
                        builder.AppendLine("[");
                        foreach (var item in GroupByEntities)
                        {
                            builder.AppendLine($"    '{item.ToString()}'");
                        }
                        builder.AppendLine("  ]");
                    }
                }
            }

            hasPropertyOverride = hasObjectOverride && propertyOverrides.TryGetValue(nameof(GroupByAlertDetails), out propertyOverride);
            if (hasPropertyOverride)
            {
                builder.Append("  groupByAlertDetails: ");
                builder.AppendLine(propertyOverride);
            }
            else
            {
                if (Optional.IsCollectionDefined(GroupByAlertDetails))
                {
                    if (GroupByAlertDetails.Any())
                    {
                        builder.Append("  groupByAlertDetails: ");
                        builder.AppendLine("[");
                        foreach (var item in GroupByAlertDetails)
                        {
                            builder.AppendLine($"    '{item.ToString()}'");
                        }
                        builder.AppendLine("  ]");
                    }
                }
            }

            hasPropertyOverride = hasObjectOverride && propertyOverrides.TryGetValue(nameof(GroupByCustomDetails), out propertyOverride);
            if (hasPropertyOverride)
            {
                builder.Append("  groupByCustomDetails: ");
                builder.AppendLine(propertyOverride);
            }
            else
            {
                if (Optional.IsCollectionDefined(GroupByCustomDetails))
                {
                    if (GroupByCustomDetails.Any())
                    {
                        builder.Append("  groupByCustomDetails: ");
                        builder.AppendLine("[");
                        foreach (var item in GroupByCustomDetails)
                        {
                            if (item == null)
                            {
                                builder.Append("null");
                                continue;
                            }
                            if (item.Contains(Environment.NewLine))
                            {
                                builder.AppendLine("    '''");
                                builder.AppendLine($"{item}'''");
                            }
                            else
                            {
                                builder.AppendLine($"    '{item}'");
                            }
                        }
                        builder.AppendLine("  ]");
                    }
                }
            }

            builder.AppendLine("}");
            return BinaryData.FromString(builder.ToString());
        }

        BinaryData IPersistableModel<SecurityInsightsGroupingConfiguration>.Write(ModelReaderWriterOptions options)
        {
            var format = options.Format == "W" ? ((IPersistableModel<SecurityInsightsGroupingConfiguration>)this).GetFormatFromOptions(options) : options.Format;

            switch (format)
            {
                case "J":
                    return ModelReaderWriter.Write(this, options);
                case "bicep":
                    return SerializeBicep(options);
                default:
                    throw new FormatException($"The model {nameof(SecurityInsightsGroupingConfiguration)} does not support writing '{options.Format}' format.");
            }
        }

        SecurityInsightsGroupingConfiguration IPersistableModel<SecurityInsightsGroupingConfiguration>.Create(BinaryData data, ModelReaderWriterOptions options)
        {
            var format = options.Format == "W" ? ((IPersistableModel<SecurityInsightsGroupingConfiguration>)this).GetFormatFromOptions(options) : options.Format;

            switch (format)
            {
                case "J":
                    {
                        using JsonDocument document = JsonDocument.Parse(data);
                        return DeserializeSecurityInsightsGroupingConfiguration(document.RootElement, options);
                    }
                default:
                    throw new FormatException($"The model {nameof(SecurityInsightsGroupingConfiguration)} does not support reading '{options.Format}' format.");
            }
        }

        string IPersistableModel<SecurityInsightsGroupingConfiguration>.GetFormatFromOptions(ModelReaderWriterOptions options) => "J";
    }
}
