// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;

namespace Azure.ResourceManager.SecurityInsights.Models
{
    /// <summary> Describes an error encountered in the file during validation. </summary>
    public partial class SecurityInsightsFileValidationError
    {
        /// <summary>
        /// Keeps track of any properties unknown to the library.
        /// <para>
        /// To assign an object to the value of this property use <see cref="BinaryData.FromObjectAsJson{T}(T, System.Text.Json.JsonSerializerOptions?)"/>.
        /// </para>
        /// <para>
        /// To assign an already formatted json string to this property use <see cref="BinaryData.FromString(string)"/>.
        /// </para>
        /// <para>
        /// Examples:
        /// <list type="bullet">
        /// <item>
        /// <term>BinaryData.FromObjectAsJson("foo")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("\"foo\"")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromObjectAsJson(new { key = "value" })</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("{\"key\": \"value\"}")</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// </list>
        /// </para>
        /// </summary>
        private IDictionary<string, BinaryData> _serializedAdditionalRawData;

        /// <summary> Initializes a new instance of <see cref="SecurityInsightsFileValidationError"/>. </summary>
        internal SecurityInsightsFileValidationError()
        {
            ErrorMessages = new ChangeTrackingList<string>();
        }

        /// <summary> Initializes a new instance of <see cref="SecurityInsightsFileValidationError"/>. </summary>
        /// <param name="recordIndex"> The number of the record that has the error. </param>
        /// <param name="errorMessages"> A list of descriptions of the error. </param>
        /// <param name="serializedAdditionalRawData"> Keeps track of any properties unknown to the library. </param>
        internal SecurityInsightsFileValidationError(int? recordIndex, IReadOnlyList<string> errorMessages, IDictionary<string, BinaryData> serializedAdditionalRawData)
        {
            RecordIndex = recordIndex;
            ErrorMessages = errorMessages;
            _serializedAdditionalRawData = serializedAdditionalRawData;
        }

        /// <summary> The number of the record that has the error. </summary>
        [WirePath("recordIndex")]
        public int? RecordIndex { get; }
        /// <summary> A list of descriptions of the error. </summary>
        [WirePath("errorMessages")]
        public IReadOnlyList<string> ErrorMessages { get; }
    }
}
