// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ClientModel.Primitives;
using System.Collections.Generic;
using System.Text;
using System.Text.Json;
using Azure.Core;

namespace Azure.ResourceManager.SecurityInsights.Models
{
    public partial class SecurityInsightsFileMetadata : IUtf8JsonSerializable, IJsonModel<SecurityInsightsFileMetadata>
    {
        void IUtf8JsonSerializable.Write(Utf8JsonWriter writer) => ((IJsonModel<SecurityInsightsFileMetadata>)this).Write(writer, ModelSerializationExtensions.WireOptions);

        void IJsonModel<SecurityInsightsFileMetadata>.Write(Utf8JsonWriter writer, ModelReaderWriterOptions options)
        {
            writer.WriteStartObject();
            JsonModelWriteCore(writer, options);
            writer.WriteEndObject();
        }

        /// <param name="writer"> The JSON writer. </param>
        /// <param name="options"> The client options for reading and writing models. </param>
        protected virtual void JsonModelWriteCore(Utf8JsonWriter writer, ModelReaderWriterOptions options)
        {
            var format = options.Format == "W" ? ((IPersistableModel<SecurityInsightsFileMetadata>)this).GetFormatFromOptions(options) : options.Format;
            if (format != "J")
            {
                throw new FormatException($"The model {nameof(SecurityInsightsFileMetadata)} does not support writing '{format}' format.");
            }

            if (Optional.IsDefined(FileFormat))
            {
                writer.WritePropertyName("fileFormat"u8);
                writer.WriteStringValue(FileFormat.Value.ToString());
            }
            if (Optional.IsDefined(FileName))
            {
                writer.WritePropertyName("fileName"u8);
                writer.WriteStringValue(FileName);
            }
            if (Optional.IsDefined(FileSize))
            {
                writer.WritePropertyName("fileSize"u8);
                writer.WriteNumberValue(FileSize.Value);
            }
            if (options.Format != "W" && Optional.IsDefined(FileContentUri))
            {
                writer.WritePropertyName("fileContentUri"u8);
                writer.WriteStringValue(FileContentUri.AbsoluteUri);
            }
            if (options.Format != "W" && Optional.IsDefined(DeleteStatus))
            {
                writer.WritePropertyName("deleteStatus"u8);
                writer.WriteStringValue(DeleteStatus.Value.ToString());
            }
            if (options.Format != "W" && _serializedAdditionalRawData != null)
            {
                foreach (var item in _serializedAdditionalRawData)
                {
                    writer.WritePropertyName(item.Key);
#if NET6_0_OR_GREATER
				writer.WriteRawValue(item.Value);
#else
                    using (JsonDocument document = JsonDocument.Parse(item.Value))
                    {
                        JsonSerializer.Serialize(writer, document.RootElement);
                    }
#endif
                }
            }
        }

        SecurityInsightsFileMetadata IJsonModel<SecurityInsightsFileMetadata>.Create(ref Utf8JsonReader reader, ModelReaderWriterOptions options)
        {
            var format = options.Format == "W" ? ((IPersistableModel<SecurityInsightsFileMetadata>)this).GetFormatFromOptions(options) : options.Format;
            if (format != "J")
            {
                throw new FormatException($"The model {nameof(SecurityInsightsFileMetadata)} does not support reading '{format}' format.");
            }

            using JsonDocument document = JsonDocument.ParseValue(ref reader);
            return DeserializeSecurityInsightsFileMetadata(document.RootElement, options);
        }

        internal static SecurityInsightsFileMetadata DeserializeSecurityInsightsFileMetadata(JsonElement element, ModelReaderWriterOptions options = null)
        {
            options ??= ModelSerializationExtensions.WireOptions;

            if (element.ValueKind == JsonValueKind.Null)
            {
                return null;
            }
            SecurityInsightsFileFormat? fileFormat = default;
            string fileName = default;
            int? fileSize = default;
            Uri fileContentUri = default;
            SecurityInsightsFileDeleteStatus? deleteStatus = default;
            IDictionary<string, BinaryData> serializedAdditionalRawData = default;
            Dictionary<string, BinaryData> rawDataDictionary = new Dictionary<string, BinaryData>();
            foreach (var property in element.EnumerateObject())
            {
                if (property.NameEquals("fileFormat"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    fileFormat = new SecurityInsightsFileFormat(property.Value.GetString());
                    continue;
                }
                if (property.NameEquals("fileName"u8))
                {
                    fileName = property.Value.GetString();
                    continue;
                }
                if (property.NameEquals("fileSize"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    fileSize = property.Value.GetInt32();
                    continue;
                }
                if (property.NameEquals("fileContentUri"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    fileContentUri = new Uri(property.Value.GetString());
                    continue;
                }
                if (property.NameEquals("deleteStatus"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    deleteStatus = new SecurityInsightsFileDeleteStatus(property.Value.GetString());
                    continue;
                }
                if (options.Format != "W")
                {
                    rawDataDictionary.Add(property.Name, BinaryData.FromString(property.Value.GetRawText()));
                }
            }
            serializedAdditionalRawData = rawDataDictionary;
            return new SecurityInsightsFileMetadata(
                fileFormat,
                fileName,
                fileSize,
                fileContentUri,
                deleteStatus,
                serializedAdditionalRawData);
        }

        private BinaryData SerializeBicep(ModelReaderWriterOptions options)
        {
            StringBuilder builder = new StringBuilder();
            BicepModelReaderWriterOptions bicepOptions = options as BicepModelReaderWriterOptions;
            IDictionary<string, string> propertyOverrides = null;
            bool hasObjectOverride = bicepOptions != null && bicepOptions.PropertyOverrides.TryGetValue(this, out propertyOverrides);
            bool hasPropertyOverride = false;
            string propertyOverride = null;

            builder.AppendLine("{");

            hasPropertyOverride = hasObjectOverride && propertyOverrides.TryGetValue(nameof(FileFormat), out propertyOverride);
            if (hasPropertyOverride)
            {
                builder.Append("  fileFormat: ");
                builder.AppendLine(propertyOverride);
            }
            else
            {
                if (Optional.IsDefined(FileFormat))
                {
                    builder.Append("  fileFormat: ");
                    builder.AppendLine($"'{FileFormat.Value.ToString()}'");
                }
            }

            hasPropertyOverride = hasObjectOverride && propertyOverrides.TryGetValue(nameof(FileName), out propertyOverride);
            if (hasPropertyOverride)
            {
                builder.Append("  fileName: ");
                builder.AppendLine(propertyOverride);
            }
            else
            {
                if (Optional.IsDefined(FileName))
                {
                    builder.Append("  fileName: ");
                    if (FileName.Contains(Environment.NewLine))
                    {
                        builder.AppendLine("'''");
                        builder.AppendLine($"{FileName}'''");
                    }
                    else
                    {
                        builder.AppendLine($"'{FileName}'");
                    }
                }
            }

            hasPropertyOverride = hasObjectOverride && propertyOverrides.TryGetValue(nameof(FileSize), out propertyOverride);
            if (hasPropertyOverride)
            {
                builder.Append("  fileSize: ");
                builder.AppendLine(propertyOverride);
            }
            else
            {
                if (Optional.IsDefined(FileSize))
                {
                    builder.Append("  fileSize: ");
                    builder.AppendLine($"{FileSize.Value}");
                }
            }

            hasPropertyOverride = hasObjectOverride && propertyOverrides.TryGetValue(nameof(FileContentUri), out propertyOverride);
            if (hasPropertyOverride)
            {
                builder.Append("  fileContentUri: ");
                builder.AppendLine(propertyOverride);
            }
            else
            {
                if (Optional.IsDefined(FileContentUri))
                {
                    builder.Append("  fileContentUri: ");
                    builder.AppendLine($"'{FileContentUri.AbsoluteUri}'");
                }
            }

            hasPropertyOverride = hasObjectOverride && propertyOverrides.TryGetValue(nameof(DeleteStatus), out propertyOverride);
            if (hasPropertyOverride)
            {
                builder.Append("  deleteStatus: ");
                builder.AppendLine(propertyOverride);
            }
            else
            {
                if (Optional.IsDefined(DeleteStatus))
                {
                    builder.Append("  deleteStatus: ");
                    builder.AppendLine($"'{DeleteStatus.Value.ToString()}'");
                }
            }

            builder.AppendLine("}");
            return BinaryData.FromString(builder.ToString());
        }

        BinaryData IPersistableModel<SecurityInsightsFileMetadata>.Write(ModelReaderWriterOptions options)
        {
            var format = options.Format == "W" ? ((IPersistableModel<SecurityInsightsFileMetadata>)this).GetFormatFromOptions(options) : options.Format;

            switch (format)
            {
                case "J":
                    return ModelReaderWriter.Write(this, options);
                case "bicep":
                    return SerializeBicep(options);
                default:
                    throw new FormatException($"The model {nameof(SecurityInsightsFileMetadata)} does not support writing '{options.Format}' format.");
            }
        }

        SecurityInsightsFileMetadata IPersistableModel<SecurityInsightsFileMetadata>.Create(BinaryData data, ModelReaderWriterOptions options)
        {
            var format = options.Format == "W" ? ((IPersistableModel<SecurityInsightsFileMetadata>)this).GetFormatFromOptions(options) : options.Format;

            switch (format)
            {
                case "J":
                    {
                        using JsonDocument document = JsonDocument.Parse(data);
                        return DeserializeSecurityInsightsFileMetadata(document.RootElement, options);
                    }
                default:
                    throw new FormatException($"The model {nameof(SecurityInsightsFileMetadata)} does not support reading '{options.Format}' format.");
            }
        }

        string IPersistableModel<SecurityInsightsFileMetadata>.GetFormatFromOptions(ModelReaderWriterOptions options) => "J";
    }
}
