// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ComponentModel;

namespace Azure.ResourceManager.SecurityInsights.Models
{
    /// <summary> The state of the file import. </summary>
    public readonly partial struct SecurityInsightsFileImportState : IEquatable<SecurityInsightsFileImportState>
    {
        private readonly string _value;

        /// <summary> Initializes a new instance of <see cref="SecurityInsightsFileImportState"/>. </summary>
        /// <exception cref="ArgumentNullException"> <paramref name="value"/> is null. </exception>
        public SecurityInsightsFileImportState(string value)
        {
            _value = value ?? throw new ArgumentNullException(nameof(value));
        }

        private const string FatalErrorValue = "FatalError";
        private const string IngestedValue = "Ingested";
        private const string IngestedWithErrorsValue = "IngestedWithErrors";
        private const string InProgressValue = "InProgress";
        private const string InvalidValue = "Invalid";
        private const string WaitingForUploadValue = "WaitingForUpload";
        private const string UnspecifiedValue = "Unspecified";

        /// <summary> A fatal error has occurred while ingesting the file. </summary>
        public static SecurityInsightsFileImportState FatalError { get; } = new SecurityInsightsFileImportState(FatalErrorValue);
        /// <summary> The file has been ingested. </summary>
        public static SecurityInsightsFileImportState Ingested { get; } = new SecurityInsightsFileImportState(IngestedValue);
        /// <summary> The file has been ingested with errors. </summary>
        public static SecurityInsightsFileImportState IngestedWithErrors { get; } = new SecurityInsightsFileImportState(IngestedWithErrorsValue);
        /// <summary> The file ingestion is in progress. </summary>
        public static SecurityInsightsFileImportState InProgress { get; } = new SecurityInsightsFileImportState(InProgressValue);
        /// <summary> The file is invalid. </summary>
        public static SecurityInsightsFileImportState Invalid { get; } = new SecurityInsightsFileImportState(InvalidValue);
        /// <summary> Waiting for the file to be uploaded. </summary>
        public static SecurityInsightsFileImportState WaitingForUpload { get; } = new SecurityInsightsFileImportState(WaitingForUploadValue);
        /// <summary> Unspecified state. </summary>
        public static SecurityInsightsFileImportState Unspecified { get; } = new SecurityInsightsFileImportState(UnspecifiedValue);
        /// <summary> Determines if two <see cref="SecurityInsightsFileImportState"/> values are the same. </summary>
        public static bool operator ==(SecurityInsightsFileImportState left, SecurityInsightsFileImportState right) => left.Equals(right);
        /// <summary> Determines if two <see cref="SecurityInsightsFileImportState"/> values are not the same. </summary>
        public static bool operator !=(SecurityInsightsFileImportState left, SecurityInsightsFileImportState right) => !left.Equals(right);
        /// <summary> Converts a <see cref="string"/> to a <see cref="SecurityInsightsFileImportState"/>. </summary>
        public static implicit operator SecurityInsightsFileImportState(string value) => new SecurityInsightsFileImportState(value);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override bool Equals(object obj) => obj is SecurityInsightsFileImportState other && Equals(other);
        /// <inheritdoc />
        public bool Equals(SecurityInsightsFileImportState other) => string.Equals(_value, other._value, StringComparison.InvariantCultureIgnoreCase);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override int GetHashCode() => _value != null ? StringComparer.InvariantCultureIgnoreCase.GetHashCode(_value) : 0;
        /// <inheritdoc />
        public override string ToString() => _value;
    }
}
