// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ComponentModel;

namespace Azure.ResourceManager.SecurityInsights.Models
{
    /// <summary> The hash algorithm type. </summary>
    public readonly partial struct SecurityInsightsFileHashAlgorithm : IEquatable<SecurityInsightsFileHashAlgorithm>
    {
        private readonly string _value;

        /// <summary> Initializes a new instance of <see cref="SecurityInsightsFileHashAlgorithm"/>. </summary>
        /// <exception cref="ArgumentNullException"> <paramref name="value"/> is null. </exception>
        public SecurityInsightsFileHashAlgorithm(string value)
        {
            _value = value ?? throw new ArgumentNullException(nameof(value));
        }

        private const string UnknownValue = "Unknown";
        private const string MD5Value = "MD5";
        private const string Sha1Value = "SHA1";
        private const string Sha256Value = "SHA256";
        private const string Sha256ACValue = "SHA256AC";

        /// <summary> Unknown hash algorithm. </summary>
        public static SecurityInsightsFileHashAlgorithm Unknown { get; } = new SecurityInsightsFileHashAlgorithm(UnknownValue);
        /// <summary> MD5 hash type. </summary>
        public static SecurityInsightsFileHashAlgorithm MD5 { get; } = new SecurityInsightsFileHashAlgorithm(MD5Value);
        /// <summary> SHA1 hash type. </summary>
        public static SecurityInsightsFileHashAlgorithm Sha1 { get; } = new SecurityInsightsFileHashAlgorithm(Sha1Value);
        /// <summary> SHA256 hash type. </summary>
        public static SecurityInsightsFileHashAlgorithm Sha256 { get; } = new SecurityInsightsFileHashAlgorithm(Sha256Value);
        /// <summary> SHA256 Authenticode hash type. </summary>
        public static SecurityInsightsFileHashAlgorithm Sha256AC { get; } = new SecurityInsightsFileHashAlgorithm(Sha256ACValue);
        /// <summary> Determines if two <see cref="SecurityInsightsFileHashAlgorithm"/> values are the same. </summary>
        public static bool operator ==(SecurityInsightsFileHashAlgorithm left, SecurityInsightsFileHashAlgorithm right) => left.Equals(right);
        /// <summary> Determines if two <see cref="SecurityInsightsFileHashAlgorithm"/> values are not the same. </summary>
        public static bool operator !=(SecurityInsightsFileHashAlgorithm left, SecurityInsightsFileHashAlgorithm right) => !left.Equals(right);
        /// <summary> Converts a <see cref="string"/> to a <see cref="SecurityInsightsFileHashAlgorithm"/>. </summary>
        public static implicit operator SecurityInsightsFileHashAlgorithm(string value) => new SecurityInsightsFileHashAlgorithm(value);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override bool Equals(object obj) => obj is SecurityInsightsFileHashAlgorithm other && Equals(other);
        /// <inheritdoc />
        public bool Equals(SecurityInsightsFileHashAlgorithm other) => string.Equals(_value, other._value, StringComparison.InvariantCultureIgnoreCase);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override int GetHashCode() => _value != null ? StringComparer.InvariantCultureIgnoreCase.GetHashCode(_value) : 0;
        /// <inheritdoc />
        public override string ToString() => _value;
    }
}
