// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;

namespace Azure.ResourceManager.SecurityInsights.Models
{
    /// <summary> A single field mapping of the mapped entity. </summary>
    public partial class SecurityInsightsFieldMapping
    {
        /// <summary>
        /// Keeps track of any properties unknown to the library.
        /// <para>
        /// To assign an object to the value of this property use <see cref="BinaryData.FromObjectAsJson{T}(T, System.Text.Json.JsonSerializerOptions?)"/>.
        /// </para>
        /// <para>
        /// To assign an already formatted json string to this property use <see cref="BinaryData.FromString(string)"/>.
        /// </para>
        /// <para>
        /// Examples:
        /// <list type="bullet">
        /// <item>
        /// <term>BinaryData.FromObjectAsJson("foo")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("\"foo\"")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromObjectAsJson(new { key = "value" })</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("{\"key\": \"value\"}")</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// </list>
        /// </para>
        /// </summary>
        private IDictionary<string, BinaryData> _serializedAdditionalRawData;

        /// <summary> Initializes a new instance of <see cref="SecurityInsightsFieldMapping"/>. </summary>
        public SecurityInsightsFieldMapping()
        {
        }

        /// <summary> Initializes a new instance of <see cref="SecurityInsightsFieldMapping"/>. </summary>
        /// <param name="identifier"> the V3 identifier of the entity. </param>
        /// <param name="columnName"> the column name to be mapped to the identifier. </param>
        /// <param name="serializedAdditionalRawData"> Keeps track of any properties unknown to the library. </param>
        internal SecurityInsightsFieldMapping(string identifier, string columnName, IDictionary<string, BinaryData> serializedAdditionalRawData)
        {
            Identifier = identifier;
            ColumnName = columnName;
            _serializedAdditionalRawData = serializedAdditionalRawData;
        }

        /// <summary> the V3 identifier of the entity. </summary>
        [WirePath("identifier")]
        public string Identifier { get; set; }
        /// <summary> the column name to be mapped to the identifier. </summary>
        [WirePath("columnName")]
        public string ColumnName { get; set; }
    }
}
