// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ComponentModel;

namespace Azure.ResourceManager.SecurityInsights.Models
{
    /// <summary> Describe whether this data type connection is enabled or not. </summary>
    public readonly partial struct SecurityInsightsDataTypeConnectionState : IEquatable<SecurityInsightsDataTypeConnectionState>
    {
        private readonly string _value;

        /// <summary> Initializes a new instance of <see cref="SecurityInsightsDataTypeConnectionState"/>. </summary>
        /// <exception cref="ArgumentNullException"> <paramref name="value"/> is null. </exception>
        public SecurityInsightsDataTypeConnectionState(string value)
        {
            _value = value ?? throw new ArgumentNullException(nameof(value));
        }

        private const string EnabledValue = "Enabled";
        private const string DisabledValue = "Disabled";

        /// <summary> Enabled. </summary>
        public static SecurityInsightsDataTypeConnectionState Enabled { get; } = new SecurityInsightsDataTypeConnectionState(EnabledValue);
        /// <summary> Disabled. </summary>
        public static SecurityInsightsDataTypeConnectionState Disabled { get; } = new SecurityInsightsDataTypeConnectionState(DisabledValue);
        /// <summary> Determines if two <see cref="SecurityInsightsDataTypeConnectionState"/> values are the same. </summary>
        public static bool operator ==(SecurityInsightsDataTypeConnectionState left, SecurityInsightsDataTypeConnectionState right) => left.Equals(right);
        /// <summary> Determines if two <see cref="SecurityInsightsDataTypeConnectionState"/> values are not the same. </summary>
        public static bool operator !=(SecurityInsightsDataTypeConnectionState left, SecurityInsightsDataTypeConnectionState right) => !left.Equals(right);
        /// <summary> Converts a <see cref="string"/> to a <see cref="SecurityInsightsDataTypeConnectionState"/>. </summary>
        public static implicit operator SecurityInsightsDataTypeConnectionState(string value) => new SecurityInsightsDataTypeConnectionState(value);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override bool Equals(object obj) => obj is SecurityInsightsDataTypeConnectionState other && Equals(other);
        /// <inheritdoc />
        public bool Equals(SecurityInsightsDataTypeConnectionState other) => string.Equals(_value, other._value, StringComparison.InvariantCultureIgnoreCase);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override int GetHashCode() => _value != null ? StringComparer.InvariantCultureIgnoreCase.GetHashCode(_value) : 0;
        /// <inheritdoc />
        public override string ToString() => _value;
    }
}
