// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;

namespace Azure.ResourceManager.SecurityInsights.Models
{
    /// <summary> Describes related incident information for the bookmark. </summary>
    public partial class SecurityInsightsBookmarkIncidentInfo
    {
        /// <summary>
        /// Keeps track of any properties unknown to the library.
        /// <para>
        /// To assign an object to the value of this property use <see cref="BinaryData.FromObjectAsJson{T}(T, System.Text.Json.JsonSerializerOptions?)"/>.
        /// </para>
        /// <para>
        /// To assign an already formatted json string to this property use <see cref="BinaryData.FromString(string)"/>.
        /// </para>
        /// <para>
        /// Examples:
        /// <list type="bullet">
        /// <item>
        /// <term>BinaryData.FromObjectAsJson("foo")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("\"foo\"")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromObjectAsJson(new { key = "value" })</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("{\"key\": \"value\"}")</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// </list>
        /// </para>
        /// </summary>
        private IDictionary<string, BinaryData> _serializedAdditionalRawData;

        /// <summary> Initializes a new instance of <see cref="SecurityInsightsBookmarkIncidentInfo"/>. </summary>
        public SecurityInsightsBookmarkIncidentInfo()
        {
        }

        /// <summary> Initializes a new instance of <see cref="SecurityInsightsBookmarkIncidentInfo"/>. </summary>
        /// <param name="incidentId"> Incident Id. </param>
        /// <param name="severity"> The severity of the incident. </param>
        /// <param name="title"> The title of the incident. </param>
        /// <param name="relationName"> Relation Name. </param>
        /// <param name="serializedAdditionalRawData"> Keeps track of any properties unknown to the library. </param>
        internal SecurityInsightsBookmarkIncidentInfo(Guid? incidentId, SecurityInsightsIncidentSeverity? severity, string title, string relationName, IDictionary<string, BinaryData> serializedAdditionalRawData)
        {
            IncidentId = incidentId;
            Severity = severity;
            Title = title;
            RelationName = relationName;
            _serializedAdditionalRawData = serializedAdditionalRawData;
        }

        /// <summary> Incident Id. </summary>
        [WirePath("incidentId")]
        public Guid? IncidentId { get; set; }
        /// <summary> The severity of the incident. </summary>
        [WirePath("severity")]
        public SecurityInsightsIncidentSeverity? Severity { get; set; }
        /// <summary> The title of the incident. </summary>
        [WirePath("title")]
        public string Title { get; set; }
        /// <summary> Relation Name. </summary>
        [WirePath("relationName")]
        public string RelationName { get; set; }
    }
}
