// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;
using Azure.Core;
using Azure.ResourceManager.Models;

namespace Azure.ResourceManager.SecurityInsights.Models
{
    /// <summary> Represents Amazon Web Services CloudTrail data connector. </summary>
    public partial class SecurityInsightsAwsCloudTrailDataConnector : SecurityInsightsDataConnectorData
    {
        /// <summary> Initializes a new instance of <see cref="SecurityInsightsAwsCloudTrailDataConnector"/>. </summary>
        public SecurityInsightsAwsCloudTrailDataConnector()
        {
            Kind = DataConnectorKind.AmazonWebServicesCloudTrail;
        }

        /// <summary> Initializes a new instance of <see cref="SecurityInsightsAwsCloudTrailDataConnector"/>. </summary>
        /// <param name="id"> The id. </param>
        /// <param name="name"> The name. </param>
        /// <param name="resourceType"> The resourceType. </param>
        /// <param name="systemData"> The systemData. </param>
        /// <param name="kind"> The data connector kind. </param>
        /// <param name="etag"> Etag of the azure resource. </param>
        /// <param name="serializedAdditionalRawData"> Keeps track of any properties unknown to the library. </param>
        /// <param name="awsRoleArn"> The Aws Role Arn (with CloudTrailReadOnly policy) that is used to access the Aws account. </param>
        /// <param name="logs"> Logs data type. </param>
        internal SecurityInsightsAwsCloudTrailDataConnector(ResourceIdentifier id, string name, ResourceType resourceType, SystemData systemData, DataConnectorKind kind, ETag? etag, IDictionary<string, BinaryData> serializedAdditionalRawData, string awsRoleArn, DataConnectorDataTypeCommon logs) : base(id, name, resourceType, systemData, kind, etag, serializedAdditionalRawData)
        {
            AwsRoleArn = awsRoleArn;
            Logs = logs;
            Kind = kind;
        }

        /// <summary> The Aws Role Arn (with CloudTrailReadOnly policy) that is used to access the Aws account. </summary>
        [WirePath("properties.awsRoleArn")]
        public string AwsRoleArn { get; set; }
        /// <summary> Logs data type. </summary>
        internal DataConnectorDataTypeCommon Logs { get; set; }
        /// <summary> Describe whether this data type connection is enabled or not. </summary>
        [WirePath("properties.logs.state")]
        public SecurityInsightsDataTypeConnectionState? LogsState
        {
            get => Logs is null ? default(SecurityInsightsDataTypeConnectionState?) : Logs.State;
            set
            {
                Logs = value.HasValue ? new DataConnectorDataTypeCommon(value.Value) : null;
            }
        }
    }
}
