// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;
using Azure.Core;
using Azure.ResourceManager.Models;

namespace Azure.ResourceManager.SecurityInsights.Models
{
    /// <summary> Represents ASC (Azure Security Center) data connector. </summary>
    public partial class SecurityInsightsAscDataConnector : SecurityInsightsDataConnectorData
    {
        /// <summary> Initializes a new instance of <see cref="SecurityInsightsAscDataConnector"/>. </summary>
        public SecurityInsightsAscDataConnector()
        {
            Kind = DataConnectorKind.AzureSecurityCenter;
        }

        /// <summary> Initializes a new instance of <see cref="SecurityInsightsAscDataConnector"/>. </summary>
        /// <param name="id"> The id. </param>
        /// <param name="name"> The name. </param>
        /// <param name="resourceType"> The resourceType. </param>
        /// <param name="systemData"> The systemData. </param>
        /// <param name="kind"> The data connector kind. </param>
        /// <param name="etag"> Etag of the azure resource. </param>
        /// <param name="serializedAdditionalRawData"> Keeps track of any properties unknown to the library. </param>
        /// <param name="alerts"> Alerts data type connection. </param>
        /// <param name="subscriptionId"> The subscription id to connect to, and get the data from. </param>
        internal SecurityInsightsAscDataConnector(ResourceIdentifier id, string name, ResourceType resourceType, SystemData systemData, DataConnectorKind kind, ETag? etag, IDictionary<string, BinaryData> serializedAdditionalRawData, DataConnectorDataTypeCommon alerts, string subscriptionId) : base(id, name, resourceType, systemData, kind, etag, serializedAdditionalRawData)
        {
            Alerts = alerts;
            SubscriptionId = subscriptionId;
            Kind = kind;
        }

        /// <summary> Alerts data type connection. </summary>
        internal DataConnectorDataTypeCommon Alerts { get; set; }
        /// <summary> Describe whether this data type connection is enabled or not. </summary>
        [WirePath("properties.alerts.state")]
        public SecurityInsightsDataTypeConnectionState? AlertsState
        {
            get => Alerts is null ? default(SecurityInsightsDataTypeConnectionState?) : Alerts.State;
            set
            {
                Alerts = value.HasValue ? new DataConnectorDataTypeCommon(value.Value) : null;
            }
        }

        /// <summary> The subscription id to connect to, and get the data from. </summary>
        [WirePath("properties.subscriptionId")]
        public string SubscriptionId { get; set; }
    }
}
