// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ComponentModel;

namespace Azure.ResourceManager.SecurityInsights.Models
{
    /// <summary> The lifecycle status of the alert. </summary>
    public readonly partial struct SecurityInsightsAlertStatus : IEquatable<SecurityInsightsAlertStatus>
    {
        private readonly string _value;

        /// <summary> Initializes a new instance of <see cref="SecurityInsightsAlertStatus"/>. </summary>
        /// <exception cref="ArgumentNullException"> <paramref name="value"/> is null. </exception>
        public SecurityInsightsAlertStatus(string value)
        {
            _value = value ?? throw new ArgumentNullException(nameof(value));
        }

        private const string UnknownValue = "Unknown";
        private const string NewValue = "New";
        private const string ResolvedValue = "Resolved";
        private const string DismissedValue = "Dismissed";
        private const string InProgressValue = "InProgress";

        /// <summary> Unknown value. </summary>
        public static SecurityInsightsAlertStatus Unknown { get; } = new SecurityInsightsAlertStatus(UnknownValue);
        /// <summary> New alert. </summary>
        public static SecurityInsightsAlertStatus New { get; } = new SecurityInsightsAlertStatus(NewValue);
        /// <summary> Alert closed after handling. </summary>
        public static SecurityInsightsAlertStatus Resolved { get; } = new SecurityInsightsAlertStatus(ResolvedValue);
        /// <summary> Alert dismissed as false positive. </summary>
        public static SecurityInsightsAlertStatus Dismissed { get; } = new SecurityInsightsAlertStatus(DismissedValue);
        /// <summary> Alert is being handled. </summary>
        public static SecurityInsightsAlertStatus InProgress { get; } = new SecurityInsightsAlertStatus(InProgressValue);
        /// <summary> Determines if two <see cref="SecurityInsightsAlertStatus"/> values are the same. </summary>
        public static bool operator ==(SecurityInsightsAlertStatus left, SecurityInsightsAlertStatus right) => left.Equals(right);
        /// <summary> Determines if two <see cref="SecurityInsightsAlertStatus"/> values are not the same. </summary>
        public static bool operator !=(SecurityInsightsAlertStatus left, SecurityInsightsAlertStatus right) => !left.Equals(right);
        /// <summary> Converts a <see cref="string"/> to a <see cref="SecurityInsightsAlertStatus"/>. </summary>
        public static implicit operator SecurityInsightsAlertStatus(string value) => new SecurityInsightsAlertStatus(value);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override bool Equals(object obj) => obj is SecurityInsightsAlertStatus other && Equals(other);
        /// <inheritdoc />
        public bool Equals(SecurityInsightsAlertStatus other) => string.Equals(_value, other._value, StringComparison.InvariantCultureIgnoreCase);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override int GetHashCode() => _value != null ? StringComparer.InvariantCultureIgnoreCase.GetHashCode(_value) : 0;
        /// <inheritdoc />
        public override string ToString() => _value;
    }
}
