// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ComponentModel;

namespace Azure.ResourceManager.SecurityInsights.Models
{
    /// <summary> The severity of the alert. </summary>
    public readonly partial struct SecurityInsightsAlertSeverity : IEquatable<SecurityInsightsAlertSeverity>
    {
        private readonly string _value;

        /// <summary> Initializes a new instance of <see cref="SecurityInsightsAlertSeverity"/>. </summary>
        /// <exception cref="ArgumentNullException"> <paramref name="value"/> is null. </exception>
        public SecurityInsightsAlertSeverity(string value)
        {
            _value = value ?? throw new ArgumentNullException(nameof(value));
        }

        private const string HighValue = "High";
        private const string MediumValue = "Medium";
        private const string LowValue = "Low";
        private const string InformationalValue = "Informational";

        /// <summary> High severity. </summary>
        public static SecurityInsightsAlertSeverity High { get; } = new SecurityInsightsAlertSeverity(HighValue);
        /// <summary> Medium severity. </summary>
        public static SecurityInsightsAlertSeverity Medium { get; } = new SecurityInsightsAlertSeverity(MediumValue);
        /// <summary> Low severity. </summary>
        public static SecurityInsightsAlertSeverity Low { get; } = new SecurityInsightsAlertSeverity(LowValue);
        /// <summary> Informational severity. </summary>
        public static SecurityInsightsAlertSeverity Informational { get; } = new SecurityInsightsAlertSeverity(InformationalValue);
        /// <summary> Determines if two <see cref="SecurityInsightsAlertSeverity"/> values are the same. </summary>
        public static bool operator ==(SecurityInsightsAlertSeverity left, SecurityInsightsAlertSeverity right) => left.Equals(right);
        /// <summary> Determines if two <see cref="SecurityInsightsAlertSeverity"/> values are not the same. </summary>
        public static bool operator !=(SecurityInsightsAlertSeverity left, SecurityInsightsAlertSeverity right) => !left.Equals(right);
        /// <summary> Converts a <see cref="string"/> to a <see cref="SecurityInsightsAlertSeverity"/>. </summary>
        public static implicit operator SecurityInsightsAlertSeverity(string value) => new SecurityInsightsAlertSeverity(value);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override bool Equals(object obj) => obj is SecurityInsightsAlertSeverity other && Equals(other);
        /// <inheritdoc />
        public bool Equals(SecurityInsightsAlertSeverity other) => string.Equals(_value, other._value, StringComparison.InvariantCultureIgnoreCase);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override int GetHashCode() => _value != null ? StringComparer.InvariantCultureIgnoreCase.GetHashCode(_value) : 0;
        /// <inheritdoc />
        public override string ToString() => _value;
    }
}
