// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ComponentModel;

namespace Azure.ResourceManager.SecurityInsights.Models
{
    /// <summary> The alert rule template status. </summary>
    public readonly partial struct SecurityInsightsAlertRuleTemplateStatus : IEquatable<SecurityInsightsAlertRuleTemplateStatus>
    {
        private readonly string _value;

        /// <summary> Initializes a new instance of <see cref="SecurityInsightsAlertRuleTemplateStatus"/>. </summary>
        /// <exception cref="ArgumentNullException"> <paramref name="value"/> is null. </exception>
        public SecurityInsightsAlertRuleTemplateStatus(string value)
        {
            _value = value ?? throw new ArgumentNullException(nameof(value));
        }

        private const string InstalledValue = "Installed";
        private const string AvailableValue = "Available";
        private const string NotAvailableValue = "NotAvailable";

        /// <summary> Alert rule template installed. and can not use more then once. </summary>
        public static SecurityInsightsAlertRuleTemplateStatus Installed { get; } = new SecurityInsightsAlertRuleTemplateStatus(InstalledValue);
        /// <summary> Alert rule template is available. </summary>
        public static SecurityInsightsAlertRuleTemplateStatus Available { get; } = new SecurityInsightsAlertRuleTemplateStatus(AvailableValue);
        /// <summary> Alert rule template is not available. </summary>
        public static SecurityInsightsAlertRuleTemplateStatus NotAvailable { get; } = new SecurityInsightsAlertRuleTemplateStatus(NotAvailableValue);
        /// <summary> Determines if two <see cref="SecurityInsightsAlertRuleTemplateStatus"/> values are the same. </summary>
        public static bool operator ==(SecurityInsightsAlertRuleTemplateStatus left, SecurityInsightsAlertRuleTemplateStatus right) => left.Equals(right);
        /// <summary> Determines if two <see cref="SecurityInsightsAlertRuleTemplateStatus"/> values are not the same. </summary>
        public static bool operator !=(SecurityInsightsAlertRuleTemplateStatus left, SecurityInsightsAlertRuleTemplateStatus right) => !left.Equals(right);
        /// <summary> Converts a <see cref="string"/> to a <see cref="SecurityInsightsAlertRuleTemplateStatus"/>. </summary>
        public static implicit operator SecurityInsightsAlertRuleTemplateStatus(string value) => new SecurityInsightsAlertRuleTemplateStatus(value);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override bool Equals(object obj) => obj is SecurityInsightsAlertRuleTemplateStatus other && Equals(other);
        /// <inheritdoc />
        public bool Equals(SecurityInsightsAlertRuleTemplateStatus other) => string.Equals(_value, other._value, StringComparison.InvariantCultureIgnoreCase);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override int GetHashCode() => _value != null ? StringComparer.InvariantCultureIgnoreCase.GetHashCode(_value) : 0;
        /// <inheritdoc />
        public override string ToString() => _value;
    }
}
