// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;

namespace Azure.ResourceManager.SecurityInsights.Models
{
    /// <summary> Single entity mapping for the alert rule. </summary>
    public partial class SecurityInsightsAlertRuleEntityMapping
    {
        /// <summary>
        /// Keeps track of any properties unknown to the library.
        /// <para>
        /// To assign an object to the value of this property use <see cref="BinaryData.FromObjectAsJson{T}(T, System.Text.Json.JsonSerializerOptions?)"/>.
        /// </para>
        /// <para>
        /// To assign an already formatted json string to this property use <see cref="BinaryData.FromString(string)"/>.
        /// </para>
        /// <para>
        /// Examples:
        /// <list type="bullet">
        /// <item>
        /// <term>BinaryData.FromObjectAsJson("foo")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("\"foo\"")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromObjectAsJson(new { key = "value" })</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("{\"key\": \"value\"}")</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// </list>
        /// </para>
        /// </summary>
        private IDictionary<string, BinaryData> _serializedAdditionalRawData;

        /// <summary> Initializes a new instance of <see cref="SecurityInsightsAlertRuleEntityMapping"/>. </summary>
        public SecurityInsightsAlertRuleEntityMapping()
        {
            FieldMappings = new ChangeTrackingList<SecurityInsightsFieldMapping>();
        }

        /// <summary> Initializes a new instance of <see cref="SecurityInsightsAlertRuleEntityMapping"/>. </summary>
        /// <param name="entityType"> The V3 type of the mapped entity. </param>
        /// <param name="fieldMappings"> array of field mappings for the given entity mapping. </param>
        /// <param name="serializedAdditionalRawData"> Keeps track of any properties unknown to the library. </param>
        internal SecurityInsightsAlertRuleEntityMapping(SecurityInsightsAlertRuleEntityMappingType? entityType, IList<SecurityInsightsFieldMapping> fieldMappings, IDictionary<string, BinaryData> serializedAdditionalRawData)
        {
            EntityType = entityType;
            FieldMappings = fieldMappings;
            _serializedAdditionalRawData = serializedAdditionalRawData;
        }

        /// <summary> The V3 type of the mapped entity. </summary>
        [WirePath("entityType")]
        public SecurityInsightsAlertRuleEntityMappingType? EntityType { get; set; }
        /// <summary> array of field mappings for the given entity mapping. </summary>
        [WirePath("fieldMappings")]
        public IList<SecurityInsightsFieldMapping> FieldMappings { get; }
    }
}
