// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ComponentModel;

namespace Azure.ResourceManager.SecurityInsights.Models
{
    /// <summary> The V3 alert property. </summary>
    public readonly partial struct SecurityInsightsAlertProperty : IEquatable<SecurityInsightsAlertProperty>
    {
        private readonly string _value;

        /// <summary> Initializes a new instance of <see cref="SecurityInsightsAlertProperty"/>. </summary>
        /// <exception cref="ArgumentNullException"> <paramref name="value"/> is null. </exception>
        public SecurityInsightsAlertProperty(string value)
        {
            _value = value ?? throw new ArgumentNullException(nameof(value));
        }

        private const string AlertLinkValue = "AlertLink";
        private const string ConfidenceLevelValue = "ConfidenceLevel";
        private const string ConfidenceScoreValue = "ConfidenceScore";
        private const string ExtendedLinksValue = "ExtendedLinks";
        private const string ProductNameValue = "ProductName";
        private const string ProviderNameValue = "ProviderName";
        private const string ProductComponentNameValue = "ProductComponentName";
        private const string RemediationStepsValue = "RemediationSteps";
        private const string TechniquesValue = "Techniques";
        private const string SubTechniquesValue = "SubTechniques";

        /// <summary> Alert's link. </summary>
        public static SecurityInsightsAlertProperty AlertLink { get; } = new SecurityInsightsAlertProperty(AlertLinkValue);
        /// <summary> Confidence level property. </summary>
        public static SecurityInsightsAlertProperty ConfidenceLevel { get; } = new SecurityInsightsAlertProperty(ConfidenceLevelValue);
        /// <summary> Confidence score. </summary>
        public static SecurityInsightsAlertProperty ConfidenceScore { get; } = new SecurityInsightsAlertProperty(ConfidenceScoreValue);
        /// <summary> Extended links to the alert. </summary>
        public static SecurityInsightsAlertProperty ExtendedLinks { get; } = new SecurityInsightsAlertProperty(ExtendedLinksValue);
        /// <summary> Product name alert property. </summary>
        public static SecurityInsightsAlertProperty ProductName { get; } = new SecurityInsightsAlertProperty(ProductNameValue);
        /// <summary> Provider name alert property. </summary>
        public static SecurityInsightsAlertProperty ProviderName { get; } = new SecurityInsightsAlertProperty(ProviderNameValue);
        /// <summary> Product component name alert property. </summary>
        public static SecurityInsightsAlertProperty ProductComponentName { get; } = new SecurityInsightsAlertProperty(ProductComponentNameValue);
        /// <summary> Remediation steps alert property. </summary>
        public static SecurityInsightsAlertProperty RemediationSteps { get; } = new SecurityInsightsAlertProperty(RemediationStepsValue);
        /// <summary> Techniques alert property. </summary>
        public static SecurityInsightsAlertProperty Techniques { get; } = new SecurityInsightsAlertProperty(TechniquesValue);
        /// <summary> SubTechniques alert property. </summary>
        public static SecurityInsightsAlertProperty SubTechniques { get; } = new SecurityInsightsAlertProperty(SubTechniquesValue);
        /// <summary> Determines if two <see cref="SecurityInsightsAlertProperty"/> values are the same. </summary>
        public static bool operator ==(SecurityInsightsAlertProperty left, SecurityInsightsAlertProperty right) => left.Equals(right);
        /// <summary> Determines if two <see cref="SecurityInsightsAlertProperty"/> values are not the same. </summary>
        public static bool operator !=(SecurityInsightsAlertProperty left, SecurityInsightsAlertProperty right) => !left.Equals(right);
        /// <summary> Converts a <see cref="string"/> to a <see cref="SecurityInsightsAlertProperty"/>. </summary>
        public static implicit operator SecurityInsightsAlertProperty(string value) => new SecurityInsightsAlertProperty(value);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override bool Equals(object obj) => obj is SecurityInsightsAlertProperty other && Equals(other);
        /// <inheritdoc />
        public bool Equals(SecurityInsightsAlertProperty other) => string.Equals(_value, other._value, StringComparison.InvariantCultureIgnoreCase);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override int GetHashCode() => _value != null ? StringComparer.InvariantCultureIgnoreCase.GetHashCode(_value) : 0;
        /// <inheritdoc />
        public override string ToString() => _value;
    }
}
