// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ComponentModel;

namespace Azure.ResourceManager.SecurityInsights.Models
{
    /// <summary> Alert detail. </summary>
    public readonly partial struct SecurityInsightsAlertDetail : IEquatable<SecurityInsightsAlertDetail>
    {
        private readonly string _value;

        /// <summary> Initializes a new instance of <see cref="SecurityInsightsAlertDetail"/>. </summary>
        /// <exception cref="ArgumentNullException"> <paramref name="value"/> is null. </exception>
        public SecurityInsightsAlertDetail(string value)
        {
            _value = value ?? throw new ArgumentNullException(nameof(value));
        }

        private const string DisplayNameValue = "DisplayName";
        private const string SeverityValue = "Severity";

        /// <summary> Alert display name. </summary>
        public static SecurityInsightsAlertDetail DisplayName { get; } = new SecurityInsightsAlertDetail(DisplayNameValue);
        /// <summary> Alert severity. </summary>
        public static SecurityInsightsAlertDetail Severity { get; } = new SecurityInsightsAlertDetail(SeverityValue);
        /// <summary> Determines if two <see cref="SecurityInsightsAlertDetail"/> values are the same. </summary>
        public static bool operator ==(SecurityInsightsAlertDetail left, SecurityInsightsAlertDetail right) => left.Equals(right);
        /// <summary> Determines if two <see cref="SecurityInsightsAlertDetail"/> values are not the same. </summary>
        public static bool operator !=(SecurityInsightsAlertDetail left, SecurityInsightsAlertDetail right) => !left.Equals(right);
        /// <summary> Converts a <see cref="string"/> to a <see cref="SecurityInsightsAlertDetail"/>. </summary>
        public static implicit operator SecurityInsightsAlertDetail(string value) => new SecurityInsightsAlertDetail(value);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override bool Equals(object obj) => obj is SecurityInsightsAlertDetail other && Equals(other);
        /// <inheritdoc />
        public bool Equals(SecurityInsightsAlertDetail other) => string.Equals(_value, other._value, StringComparison.InvariantCultureIgnoreCase);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override int GetHashCode() => _value != null ? StringComparer.InvariantCultureIgnoreCase.GetHashCode(_value) : 0;
        /// <inheritdoc />
        public override string ToString() => _value;
    }
}
