// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ComponentModel;

namespace Azure.ResourceManager.SecurityInsights.Models
{
    /// <summary> The confidence level of this alert. </summary>
    public readonly partial struct SecurityInsightsAlertConfidenceLevel : IEquatable<SecurityInsightsAlertConfidenceLevel>
    {
        private readonly string _value;

        /// <summary> Initializes a new instance of <see cref="SecurityInsightsAlertConfidenceLevel"/>. </summary>
        /// <exception cref="ArgumentNullException"> <paramref name="value"/> is null. </exception>
        public SecurityInsightsAlertConfidenceLevel(string value)
        {
            _value = value ?? throw new ArgumentNullException(nameof(value));
        }

        private const string UnknownValue = "Unknown";
        private const string LowValue = "Low";
        private const string HighValue = "High";

        /// <summary> Unknown confidence, the is the default value. </summary>
        public static SecurityInsightsAlertConfidenceLevel Unknown { get; } = new SecurityInsightsAlertConfidenceLevel(UnknownValue);
        /// <summary> Low confidence, meaning we have some doubts this is indeed malicious or part of an attack. </summary>
        public static SecurityInsightsAlertConfidenceLevel Low { get; } = new SecurityInsightsAlertConfidenceLevel(LowValue);
        /// <summary> High confidence that the alert is true positive malicious. </summary>
        public static SecurityInsightsAlertConfidenceLevel High { get; } = new SecurityInsightsAlertConfidenceLevel(HighValue);
        /// <summary> Determines if two <see cref="SecurityInsightsAlertConfidenceLevel"/> values are the same. </summary>
        public static bool operator ==(SecurityInsightsAlertConfidenceLevel left, SecurityInsightsAlertConfidenceLevel right) => left.Equals(right);
        /// <summary> Determines if two <see cref="SecurityInsightsAlertConfidenceLevel"/> values are not the same. </summary>
        public static bool operator !=(SecurityInsightsAlertConfidenceLevel left, SecurityInsightsAlertConfidenceLevel right) => !left.Equals(right);
        /// <summary> Converts a <see cref="string"/> to a <see cref="SecurityInsightsAlertConfidenceLevel"/>. </summary>
        public static implicit operator SecurityInsightsAlertConfidenceLevel(string value) => new SecurityInsightsAlertConfidenceLevel(value);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override bool Equals(object obj) => obj is SecurityInsightsAlertConfidenceLevel other && Equals(other);
        /// <inheritdoc />
        public bool Equals(SecurityInsightsAlertConfidenceLevel other) => string.Equals(_value, other._value, StringComparison.InvariantCultureIgnoreCase);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override int GetHashCode() => _value != null ? StringComparer.InvariantCultureIgnoreCase.GetHashCode(_value) : 0;
        /// <inheritdoc />
        public override string ToString() => _value;
    }
}
