// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;
using Azure.Core;
using Azure.ResourceManager.Models;

namespace Azure.ResourceManager.SecurityInsights.Models
{
    /// <summary> Billing statistic about the Microsoft Sentinel solution for SAP Usage. </summary>
    public partial class SapSolutionUsageStatistic : SecurityInsightsBillingStatisticData
    {
        /// <summary> Initializes a new instance of <see cref="SapSolutionUsageStatistic"/>. </summary>
        public SapSolutionUsageStatistic()
        {
            Kind = BillingStatisticKind.SapSolutionUsage;
        }

        /// <summary> Initializes a new instance of <see cref="SapSolutionUsageStatistic"/>. </summary>
        /// <param name="id"> The id. </param>
        /// <param name="name"> The name. </param>
        /// <param name="resourceType"> The resourceType. </param>
        /// <param name="systemData"> The systemData. </param>
        /// <param name="kind"> The kind of the billing statistic. </param>
        /// <param name="etag"> Resource Etag. </param>
        /// <param name="serializedAdditionalRawData"> Keeps track of any properties unknown to the library. </param>
        /// <param name="activeSystemIdCount"> The latest count of active SAP system IDs under the Microsoft Sentinel solution for SAP Usage. </param>
        internal SapSolutionUsageStatistic(ResourceIdentifier id, string name, ResourceType resourceType, SystemData systemData, BillingStatisticKind kind, ETag? etag, IDictionary<string, BinaryData> serializedAdditionalRawData, long? activeSystemIdCount) : base(id, name, resourceType, systemData, kind, etag, serializedAdditionalRawData)
        {
            ActiveSystemIdCount = activeSystemIdCount;
            Kind = kind;
        }

        /// <summary> The latest count of active SAP system IDs under the Microsoft Sentinel solution for SAP Usage. </summary>
        [WirePath("properties.activeSystemIdCount")]
        public long? ActiveSystemIdCount { get; }
    }
}
