// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ClientModel.Primitives;
using System.Collections.Generic;
using System.Text;
using System.Text.Json;
using Azure.Core;

namespace Azure.ResourceManager.SecurityInsights.Models
{
    public partial class RestApiPollerRequestPagingConfig : IUtf8JsonSerializable, IJsonModel<RestApiPollerRequestPagingConfig>
    {
        void IUtf8JsonSerializable.Write(Utf8JsonWriter writer) => ((IJsonModel<RestApiPollerRequestPagingConfig>)this).Write(writer, ModelSerializationExtensions.WireOptions);

        void IJsonModel<RestApiPollerRequestPagingConfig>.Write(Utf8JsonWriter writer, ModelReaderWriterOptions options)
        {
            writer.WriteStartObject();
            JsonModelWriteCore(writer, options);
            writer.WriteEndObject();
        }

        /// <param name="writer"> The JSON writer. </param>
        /// <param name="options"> The client options for reading and writing models. </param>
        protected virtual void JsonModelWriteCore(Utf8JsonWriter writer, ModelReaderWriterOptions options)
        {
            var format = options.Format == "W" ? ((IPersistableModel<RestApiPollerRequestPagingConfig>)this).GetFormatFromOptions(options) : options.Format;
            if (format != "J")
            {
                throw new FormatException($"The model {nameof(RestApiPollerRequestPagingConfig)} does not support writing '{format}' format.");
            }

            writer.WritePropertyName("pagingType"u8);
            writer.WriteStringValue(PagingType.ToString());
            if (Optional.IsDefined(PageSize))
            {
                writer.WritePropertyName("pageSize"u8);
                writer.WriteNumberValue(PageSize.Value);
            }
            if (Optional.IsDefined(PageSizeParameterName))
            {
                writer.WritePropertyName("pageSizeParameterName"u8);
                writer.WriteStringValue(PageSizeParameterName);
            }
            if (options.Format != "W" && _serializedAdditionalRawData != null)
            {
                foreach (var item in _serializedAdditionalRawData)
                {
                    writer.WritePropertyName(item.Key);
#if NET6_0_OR_GREATER
				writer.WriteRawValue(item.Value);
#else
                    using (JsonDocument document = JsonDocument.Parse(item.Value))
                    {
                        JsonSerializer.Serialize(writer, document.RootElement);
                    }
#endif
                }
            }
        }

        RestApiPollerRequestPagingConfig IJsonModel<RestApiPollerRequestPagingConfig>.Create(ref Utf8JsonReader reader, ModelReaderWriterOptions options)
        {
            var format = options.Format == "W" ? ((IPersistableModel<RestApiPollerRequestPagingConfig>)this).GetFormatFromOptions(options) : options.Format;
            if (format != "J")
            {
                throw new FormatException($"The model {nameof(RestApiPollerRequestPagingConfig)} does not support reading '{format}' format.");
            }

            using JsonDocument document = JsonDocument.ParseValue(ref reader);
            return DeserializeRestApiPollerRequestPagingConfig(document.RootElement, options);
        }

        internal static RestApiPollerRequestPagingConfig DeserializeRestApiPollerRequestPagingConfig(JsonElement element, ModelReaderWriterOptions options = null)
        {
            options ??= ModelSerializationExtensions.WireOptions;

            if (element.ValueKind == JsonValueKind.Null)
            {
                return null;
            }
            RestApiPollerRequestPagingKind pagingType = default;
            int? pageSize = default;
            string pageSizeParameterName = default;
            IDictionary<string, BinaryData> serializedAdditionalRawData = default;
            Dictionary<string, BinaryData> rawDataDictionary = new Dictionary<string, BinaryData>();
            foreach (var property in element.EnumerateObject())
            {
                if (property.NameEquals("pagingType"u8))
                {
                    pagingType = new RestApiPollerRequestPagingKind(property.Value.GetString());
                    continue;
                }
                if (property.NameEquals("pageSize"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    pageSize = property.Value.GetInt32();
                    continue;
                }
                if (property.NameEquals("pageSizeParameterName"u8))
                {
                    pageSizeParameterName = property.Value.GetString();
                    continue;
                }
                if (options.Format != "W")
                {
                    rawDataDictionary.Add(property.Name, BinaryData.FromString(property.Value.GetRawText()));
                }
            }
            serializedAdditionalRawData = rawDataDictionary;
            return new RestApiPollerRequestPagingConfig(pagingType, pageSize, pageSizeParameterName, serializedAdditionalRawData);
        }

        private BinaryData SerializeBicep(ModelReaderWriterOptions options)
        {
            StringBuilder builder = new StringBuilder();
            BicepModelReaderWriterOptions bicepOptions = options as BicepModelReaderWriterOptions;
            IDictionary<string, string> propertyOverrides = null;
            bool hasObjectOverride = bicepOptions != null && bicepOptions.PropertyOverrides.TryGetValue(this, out propertyOverrides);
            bool hasPropertyOverride = false;
            string propertyOverride = null;

            builder.AppendLine("{");

            hasPropertyOverride = hasObjectOverride && propertyOverrides.TryGetValue(nameof(PagingType), out propertyOverride);
            if (hasPropertyOverride)
            {
                builder.Append("  pagingType: ");
                builder.AppendLine(propertyOverride);
            }
            else
            {
                builder.Append("  pagingType: ");
                builder.AppendLine($"'{PagingType.ToString()}'");
            }

            hasPropertyOverride = hasObjectOverride && propertyOverrides.TryGetValue(nameof(PageSize), out propertyOverride);
            if (hasPropertyOverride)
            {
                builder.Append("  pageSize: ");
                builder.AppendLine(propertyOverride);
            }
            else
            {
                if (Optional.IsDefined(PageSize))
                {
                    builder.Append("  pageSize: ");
                    builder.AppendLine($"{PageSize.Value}");
                }
            }

            hasPropertyOverride = hasObjectOverride && propertyOverrides.TryGetValue(nameof(PageSizeParameterName), out propertyOverride);
            if (hasPropertyOverride)
            {
                builder.Append("  pageSizeParameterName: ");
                builder.AppendLine(propertyOverride);
            }
            else
            {
                if (Optional.IsDefined(PageSizeParameterName))
                {
                    builder.Append("  pageSizeParameterName: ");
                    if (PageSizeParameterName.Contains(Environment.NewLine))
                    {
                        builder.AppendLine("'''");
                        builder.AppendLine($"{PageSizeParameterName}'''");
                    }
                    else
                    {
                        builder.AppendLine($"'{PageSizeParameterName}'");
                    }
                }
            }

            builder.AppendLine("}");
            return BinaryData.FromString(builder.ToString());
        }

        BinaryData IPersistableModel<RestApiPollerRequestPagingConfig>.Write(ModelReaderWriterOptions options)
        {
            var format = options.Format == "W" ? ((IPersistableModel<RestApiPollerRequestPagingConfig>)this).GetFormatFromOptions(options) : options.Format;

            switch (format)
            {
                case "J":
                    return ModelReaderWriter.Write(this, options);
                case "bicep":
                    return SerializeBicep(options);
                default:
                    throw new FormatException($"The model {nameof(RestApiPollerRequestPagingConfig)} does not support writing '{options.Format}' format.");
            }
        }

        RestApiPollerRequestPagingConfig IPersistableModel<RestApiPollerRequestPagingConfig>.Create(BinaryData data, ModelReaderWriterOptions options)
        {
            var format = options.Format == "W" ? ((IPersistableModel<RestApiPollerRequestPagingConfig>)this).GetFormatFromOptions(options) : options.Format;

            switch (format)
            {
                case "J":
                    {
                        using JsonDocument document = JsonDocument.Parse(data);
                        return DeserializeRestApiPollerRequestPagingConfig(document.RootElement, options);
                    }
                default:
                    throw new FormatException($"The model {nameof(RestApiPollerRequestPagingConfig)} does not support reading '{options.Format}' format.");
            }
        }

        string IPersistableModel<RestApiPollerRequestPagingConfig>.GetFormatFromOptions(ModelReaderWriterOptions options) => "J";
    }
}
