// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;
using Azure.Core;
using Azure.ResourceManager.Models;

namespace Azure.ResourceManager.SecurityInsights.Models
{
    /// <summary> Represents Rest Api Poller data connector. </summary>
    public partial class RestApiPollerDataConnector : SecurityInsightsDataConnectorData
    {
        /// <summary> Initializes a new instance of <see cref="RestApiPollerDataConnector"/>. </summary>
        public RestApiPollerDataConnector()
        {
            AddOnAttributes = new ChangeTrackingDictionary<string, string>();
            Kind = DataConnectorKind.RestApiPoller;
        }

        /// <summary> Initializes a new instance of <see cref="RestApiPollerDataConnector"/>. </summary>
        /// <param name="id"> The id. </param>
        /// <param name="name"> The name. </param>
        /// <param name="resourceType"> The resourceType. </param>
        /// <param name="systemData"> The systemData. </param>
        /// <param name="kind"> The data connector kind. </param>
        /// <param name="etag"> Etag of the azure resource. </param>
        /// <param name="serializedAdditionalRawData"> Keeps track of any properties unknown to the library. </param>
        /// <param name="connectorDefinitionName"> The connector definition name (the dataConnectorDefinition resource id). </param>
        /// <param name="auth">
        /// The a authentication model.
        /// Please note <see cref="CcpAuthConfig"/> is the base class. According to the scenario, a derived class of the base class might need to be assigned here, or this property needs to be casted to one of the possible derived classes.
        /// The available derived classes include <see cref="SecurityInsightsApiKeyAuthModel"/>, <see cref="AwsAuthModel"/>, <see cref="BasicAuthModel"/>, <see cref="GcpAuthModel"/>, <see cref="GitHubAuthModel"/>, <see cref="JwtAuthModel"/>, <see cref="NoneAuthModel"/>, <see cref="OAuthModel"/>, <see cref="OracleAuthModel"/>, <see cref="GenericBlobSbsAuthModel"/> and <see cref="SessionAuthModel"/>.
        /// </param>
        /// <param name="request"> The request configuration. </param>
        /// <param name="dcrConfig"> The DCR related properties. </param>
        /// <param name="isActive"> Indicates whether the connector is active or not. </param>
        /// <param name="dataType"> The Log Analytics table destination. </param>
        /// <param name="response"> The response configuration. </param>
        /// <param name="paging"> The paging configuration. </param>
        /// <param name="addOnAttributes"> The add on attributes. The key name will become attribute name (a column) and the value will become the attribute value in the payload. </param>
        internal RestApiPollerDataConnector(ResourceIdentifier id, string name, ResourceType resourceType, SystemData systemData, DataConnectorKind kind, ETag? etag, IDictionary<string, BinaryData> serializedAdditionalRawData, string connectorDefinitionName, CcpAuthConfig auth, RestApiPollerRequestConfig request, DcrConfiguration dcrConfig, bool? isActive, string dataType, CcpResponseConfig response, RestApiPollerRequestPagingConfig paging, IDictionary<string, string> addOnAttributes) : base(id, name, resourceType, systemData, kind, etag, serializedAdditionalRawData)
        {
            ConnectorDefinitionName = connectorDefinitionName;
            Auth = auth;
            Request = request;
            DcrConfig = dcrConfig;
            IsActive = isActive;
            DataType = dataType;
            Response = response;
            Paging = paging;
            AddOnAttributes = addOnAttributes;
            Kind = kind;
        }

        /// <summary> The connector definition name (the dataConnectorDefinition resource id). </summary>
        [WirePath("properties.connectorDefinitionName")]
        public string ConnectorDefinitionName { get; set; }
        /// <summary>
        /// The a authentication model.
        /// Please note <see cref="CcpAuthConfig"/> is the base class. According to the scenario, a derived class of the base class might need to be assigned here, or this property needs to be casted to one of the possible derived classes.
        /// The available derived classes include <see cref="SecurityInsightsApiKeyAuthModel"/>, <see cref="AwsAuthModel"/>, <see cref="BasicAuthModel"/>, <see cref="GcpAuthModel"/>, <see cref="GitHubAuthModel"/>, <see cref="JwtAuthModel"/>, <see cref="NoneAuthModel"/>, <see cref="OAuthModel"/>, <see cref="OracleAuthModel"/>, <see cref="GenericBlobSbsAuthModel"/> and <see cref="SessionAuthModel"/>.
        /// </summary>
        [WirePath("properties.auth")]
        public CcpAuthConfig Auth { get; set; }
        /// <summary> The request configuration. </summary>
        [WirePath("properties.request")]
        public RestApiPollerRequestConfig Request { get; set; }
        /// <summary> The DCR related properties. </summary>
        [WirePath("properties.dcrConfig")]
        public DcrConfiguration DcrConfig { get; set; }
        /// <summary> Indicates whether the connector is active or not. </summary>
        [WirePath("properties.isActive")]
        public bool? IsActive { get; set; }
        /// <summary> The Log Analytics table destination. </summary>
        [WirePath("properties.dataType")]
        public string DataType { get; set; }
        /// <summary> The response configuration. </summary>
        [WirePath("properties.response")]
        public CcpResponseConfig Response { get; set; }
        /// <summary> The paging configuration. </summary>
        [WirePath("properties.paging")]
        public RestApiPollerRequestPagingConfig Paging { get; set; }
        /// <summary> The add on attributes. The key name will become attribute name (a column) and the value will become the attribute value in the payload. </summary>
        [WirePath("properties.addOnAttributes")]
        public IDictionary<string, string> AddOnAttributes { get; }
    }
}
