// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;

namespace Azure.ResourceManager.SecurityInsights.Models
{
    /// <summary> Resources created in user's repository for the source-control. </summary>
    public partial class RepositoryResourceInfo
    {
        /// <summary>
        /// Keeps track of any properties unknown to the library.
        /// <para>
        /// To assign an object to the value of this property use <see cref="BinaryData.FromObjectAsJson{T}(T, System.Text.Json.JsonSerializerOptions?)"/>.
        /// </para>
        /// <para>
        /// To assign an already formatted json string to this property use <see cref="BinaryData.FromString(string)"/>.
        /// </para>
        /// <para>
        /// Examples:
        /// <list type="bullet">
        /// <item>
        /// <term>BinaryData.FromObjectAsJson("foo")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("\"foo\"")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromObjectAsJson(new { key = "value" })</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("{\"key\": \"value\"}")</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// </list>
        /// </para>
        /// </summary>
        private IDictionary<string, BinaryData> _serializedAdditionalRawData;

        /// <summary> Initializes a new instance of <see cref="RepositoryResourceInfo"/>. </summary>
        public RepositoryResourceInfo()
        {
        }

        /// <summary> Initializes a new instance of <see cref="RepositoryResourceInfo"/>. </summary>
        /// <param name="webhook"> The webhook object created for the source-control. </param>
        /// <param name="gitHubResourceInfo"> Resources created in GitHub for this source-control. </param>
        /// <param name="azureDevOpsResourceInfo"> Resources created in Azure DevOps for this source-control. </param>
        /// <param name="serializedAdditionalRawData"> Keeps track of any properties unknown to the library. </param>
        internal RepositoryResourceInfo(SourceControlWebhook webhook, GitHubResourceInfo gitHubResourceInfo, AzureDevOpsResourceInfo azureDevOpsResourceInfo, IDictionary<string, BinaryData> serializedAdditionalRawData)
        {
            Webhook = webhook;
            GitHubResourceInfo = gitHubResourceInfo;
            AzureDevOpsResourceInfo = azureDevOpsResourceInfo;
            _serializedAdditionalRawData = serializedAdditionalRawData;
        }

        /// <summary> The webhook object created for the source-control. </summary>
        [WirePath("webhook")]
        public SourceControlWebhook Webhook { get; set; }
        /// <summary> Resources created in GitHub for this source-control. </summary>
        internal GitHubResourceInfo GitHubResourceInfo { get; }
        /// <summary> GitHub application installation id. </summary>
        [WirePath("gitHubResourceInfo.appInstallationId")]
        public string GitHubResourceInfoAppInstallationId
        {
            get => GitHubResourceInfo?.AppInstallationId;
        }

        /// <summary> Resources created in Azure DevOps for this source-control. </summary>
        [WirePath("azureDevOpsResourceInfo")]
        public AzureDevOpsResourceInfo AzureDevOpsResourceInfo { get; }
    }
}
