// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ClientModel.Primitives;
using System.Collections.Generic;
using System.Text;
using System.Text.Json;
using Azure.Core;

namespace Azure.ResourceManager.SecurityInsights.Models
{
    public partial class RepositoryResourceInfo : IUtf8JsonSerializable, IJsonModel<RepositoryResourceInfo>
    {
        void IUtf8JsonSerializable.Write(Utf8JsonWriter writer) => ((IJsonModel<RepositoryResourceInfo>)this).Write(writer, ModelSerializationExtensions.WireOptions);

        void IJsonModel<RepositoryResourceInfo>.Write(Utf8JsonWriter writer, ModelReaderWriterOptions options)
        {
            writer.WriteStartObject();
            JsonModelWriteCore(writer, options);
            writer.WriteEndObject();
        }

        /// <param name="writer"> The JSON writer. </param>
        /// <param name="options"> The client options for reading and writing models. </param>
        protected virtual void JsonModelWriteCore(Utf8JsonWriter writer, ModelReaderWriterOptions options)
        {
            var format = options.Format == "W" ? ((IPersistableModel<RepositoryResourceInfo>)this).GetFormatFromOptions(options) : options.Format;
            if (format != "J")
            {
                throw new FormatException($"The model {nameof(RepositoryResourceInfo)} does not support writing '{format}' format.");
            }

            if (Optional.IsDefined(Webhook))
            {
                writer.WritePropertyName("webhook"u8);
                writer.WriteObjectValue(Webhook, options);
            }
            if (options.Format != "W" && Optional.IsDefined(GitHubResourceInfo))
            {
                writer.WritePropertyName("gitHubResourceInfo"u8);
                writer.WriteObjectValue(GitHubResourceInfo, options);
            }
            if (options.Format != "W" && Optional.IsDefined(AzureDevOpsResourceInfo))
            {
                writer.WritePropertyName("azureDevOpsResourceInfo"u8);
                writer.WriteObjectValue(AzureDevOpsResourceInfo, options);
            }
            if (options.Format != "W" && _serializedAdditionalRawData != null)
            {
                foreach (var item in _serializedAdditionalRawData)
                {
                    writer.WritePropertyName(item.Key);
#if NET6_0_OR_GREATER
				writer.WriteRawValue(item.Value);
#else
                    using (JsonDocument document = JsonDocument.Parse(item.Value))
                    {
                        JsonSerializer.Serialize(writer, document.RootElement);
                    }
#endif
                }
            }
        }

        RepositoryResourceInfo IJsonModel<RepositoryResourceInfo>.Create(ref Utf8JsonReader reader, ModelReaderWriterOptions options)
        {
            var format = options.Format == "W" ? ((IPersistableModel<RepositoryResourceInfo>)this).GetFormatFromOptions(options) : options.Format;
            if (format != "J")
            {
                throw new FormatException($"The model {nameof(RepositoryResourceInfo)} does not support reading '{format}' format.");
            }

            using JsonDocument document = JsonDocument.ParseValue(ref reader);
            return DeserializeRepositoryResourceInfo(document.RootElement, options);
        }

        internal static RepositoryResourceInfo DeserializeRepositoryResourceInfo(JsonElement element, ModelReaderWriterOptions options = null)
        {
            options ??= ModelSerializationExtensions.WireOptions;

            if (element.ValueKind == JsonValueKind.Null)
            {
                return null;
            }
            SourceControlWebhook webhook = default;
            GitHubResourceInfo gitHubResourceInfo = default;
            AzureDevOpsResourceInfo azureDevOpsResourceInfo = default;
            IDictionary<string, BinaryData> serializedAdditionalRawData = default;
            Dictionary<string, BinaryData> rawDataDictionary = new Dictionary<string, BinaryData>();
            foreach (var property in element.EnumerateObject())
            {
                if (property.NameEquals("webhook"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    webhook = SourceControlWebhook.DeserializeSourceControlWebhook(property.Value, options);
                    continue;
                }
                if (property.NameEquals("gitHubResourceInfo"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    gitHubResourceInfo = GitHubResourceInfo.DeserializeGitHubResourceInfo(property.Value, options);
                    continue;
                }
                if (property.NameEquals("azureDevOpsResourceInfo"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    azureDevOpsResourceInfo = AzureDevOpsResourceInfo.DeserializeAzureDevOpsResourceInfo(property.Value, options);
                    continue;
                }
                if (options.Format != "W")
                {
                    rawDataDictionary.Add(property.Name, BinaryData.FromString(property.Value.GetRawText()));
                }
            }
            serializedAdditionalRawData = rawDataDictionary;
            return new RepositoryResourceInfo(webhook, gitHubResourceInfo, azureDevOpsResourceInfo, serializedAdditionalRawData);
        }

        private BinaryData SerializeBicep(ModelReaderWriterOptions options)
        {
            StringBuilder builder = new StringBuilder();
            BicepModelReaderWriterOptions bicepOptions = options as BicepModelReaderWriterOptions;
            IDictionary<string, string> propertyOverrides = null;
            bool hasObjectOverride = bicepOptions != null && bicepOptions.PropertyOverrides.TryGetValue(this, out propertyOverrides);
            bool hasPropertyOverride = false;
            string propertyOverride = null;

            builder.AppendLine("{");

            hasPropertyOverride = hasObjectOverride && propertyOverrides.TryGetValue(nameof(Webhook), out propertyOverride);
            if (hasPropertyOverride)
            {
                builder.Append("  webhook: ");
                builder.AppendLine(propertyOverride);
            }
            else
            {
                if (Optional.IsDefined(Webhook))
                {
                    builder.Append("  webhook: ");
                    BicepSerializationHelpers.AppendChildObject(builder, Webhook, options, 2, false, "  webhook: ");
                }
            }

            hasPropertyOverride = hasObjectOverride && propertyOverrides.TryGetValue("GitHubResourceInfoAppInstallationId", out propertyOverride);
            if (hasPropertyOverride)
            {
                builder.Append("  gitHubResourceInfo: ");
                builder.AppendLine("{");
                builder.Append("    appInstallationId: ");
                builder.AppendLine(propertyOverride);
                builder.AppendLine("  }");
            }
            else
            {
                if (Optional.IsDefined(GitHubResourceInfo))
                {
                    builder.Append("  gitHubResourceInfo: ");
                    BicepSerializationHelpers.AppendChildObject(builder, GitHubResourceInfo, options, 2, false, "  gitHubResourceInfo: ");
                }
            }

            hasPropertyOverride = hasObjectOverride && propertyOverrides.TryGetValue(nameof(AzureDevOpsResourceInfo), out propertyOverride);
            if (hasPropertyOverride)
            {
                builder.Append("  azureDevOpsResourceInfo: ");
                builder.AppendLine(propertyOverride);
            }
            else
            {
                if (Optional.IsDefined(AzureDevOpsResourceInfo))
                {
                    builder.Append("  azureDevOpsResourceInfo: ");
                    BicepSerializationHelpers.AppendChildObject(builder, AzureDevOpsResourceInfo, options, 2, false, "  azureDevOpsResourceInfo: ");
                }
            }

            builder.AppendLine("}");
            return BinaryData.FromString(builder.ToString());
        }

        BinaryData IPersistableModel<RepositoryResourceInfo>.Write(ModelReaderWriterOptions options)
        {
            var format = options.Format == "W" ? ((IPersistableModel<RepositoryResourceInfo>)this).GetFormatFromOptions(options) : options.Format;

            switch (format)
            {
                case "J":
                    return ModelReaderWriter.Write(this, options);
                case "bicep":
                    return SerializeBicep(options);
                default:
                    throw new FormatException($"The model {nameof(RepositoryResourceInfo)} does not support writing '{options.Format}' format.");
            }
        }

        RepositoryResourceInfo IPersistableModel<RepositoryResourceInfo>.Create(BinaryData data, ModelReaderWriterOptions options)
        {
            var format = options.Format == "W" ? ((IPersistableModel<RepositoryResourceInfo>)this).GetFormatFromOptions(options) : options.Format;

            switch (format)
            {
                case "J":
                    {
                        using JsonDocument document = JsonDocument.Parse(data);
                        return DeserializeRepositoryResourceInfo(document.RootElement, options);
                    }
                default:
                    throw new FormatException($"The model {nameof(RepositoryResourceInfo)} does not support reading '{options.Format}' format.");
            }
        }

        string IPersistableModel<RepositoryResourceInfo>.GetFormatFromOptions(ModelReaderWriterOptions options) => "J";
    }
}
