// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ClientModel.Primitives;
using System.Collections.Generic;
using System.Text.Json;
using Azure.Core;

namespace Azure.ResourceManager.SecurityInsights.Models
{
    public partial class RepositoryAccessProperties : IUtf8JsonSerializable, IJsonModel<RepositoryAccessProperties>
    {
        void IUtf8JsonSerializable.Write(Utf8JsonWriter writer) => ((IJsonModel<RepositoryAccessProperties>)this).Write(writer, ModelSerializationExtensions.WireOptions);

        void IJsonModel<RepositoryAccessProperties>.Write(Utf8JsonWriter writer, ModelReaderWriterOptions options)
        {
            writer.WriteStartObject();
            JsonModelWriteCore(writer, options);
            writer.WriteEndObject();
        }

        /// <param name="writer"> The JSON writer. </param>
        /// <param name="options"> The client options for reading and writing models. </param>
        protected virtual void JsonModelWriteCore(Utf8JsonWriter writer, ModelReaderWriterOptions options)
        {
            var format = options.Format == "W" ? ((IPersistableModel<RepositoryAccessProperties>)this).GetFormatFromOptions(options) : options.Format;
            if (format != "J")
            {
                throw new FormatException($"The model {nameof(RepositoryAccessProperties)} does not support writing '{format}' format.");
            }

            writer.WritePropertyName("properties"u8);
            writer.WriteStartObject();
            writer.WritePropertyName("repositoryAccess"u8);
            writer.WriteStartObject();
            writer.WritePropertyName("kind"u8);
            writer.WriteStringValue(Kind.ToString());
            if (Optional.IsDefined(Code))
            {
                writer.WritePropertyName("code"u8);
                writer.WriteStringValue(Code);
            }
            if (Optional.IsDefined(State))
            {
                writer.WritePropertyName("state"u8);
                writer.WriteStringValue(State);
            }
            if (Optional.IsDefined(ClientId))
            {
                writer.WritePropertyName("clientId"u8);
                writer.WriteStringValue(ClientId);
            }
            if (Optional.IsDefined(Token))
            {
                writer.WritePropertyName("token"u8);
                writer.WriteStringValue(Token);
            }
            if (Optional.IsDefined(InstallationId))
            {
                writer.WritePropertyName("installationId"u8);
                writer.WriteStringValue(InstallationId);
            }
            writer.WriteEndObject();
            writer.WriteEndObject();
            if (options.Format != "W" && _serializedAdditionalRawData != null)
            {
                foreach (var item in _serializedAdditionalRawData)
                {
                    writer.WritePropertyName(item.Key);
#if NET6_0_OR_GREATER
				writer.WriteRawValue(item.Value);
#else
                    using (JsonDocument document = JsonDocument.Parse(item.Value))
                    {
                        JsonSerializer.Serialize(writer, document.RootElement);
                    }
#endif
                }
            }
        }

        RepositoryAccessProperties IJsonModel<RepositoryAccessProperties>.Create(ref Utf8JsonReader reader, ModelReaderWriterOptions options)
        {
            var format = options.Format == "W" ? ((IPersistableModel<RepositoryAccessProperties>)this).GetFormatFromOptions(options) : options.Format;
            if (format != "J")
            {
                throw new FormatException($"The model {nameof(RepositoryAccessProperties)} does not support reading '{format}' format.");
            }

            using JsonDocument document = JsonDocument.ParseValue(ref reader);
            return DeserializeRepositoryAccessProperties(document.RootElement, options);
        }

        internal static RepositoryAccessProperties DeserializeRepositoryAccessProperties(JsonElement element, ModelReaderWriterOptions options = null)
        {
            options ??= ModelSerializationExtensions.WireOptions;

            if (element.ValueKind == JsonValueKind.Null)
            {
                return null;
            }
            RepositoryAccessKind kind = default;
            string code = default;
            string state = default;
            string clientId = default;
            string token = default;
            string installationId = default;
            IDictionary<string, BinaryData> serializedAdditionalRawData = default;
            Dictionary<string, BinaryData> rawDataDictionary = new Dictionary<string, BinaryData>();
            foreach (var property in element.EnumerateObject())
            {
                if (property.NameEquals("properties"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        property.ThrowNonNullablePropertyIsNull();
                        continue;
                    }
                    foreach (var property0 in property.Value.EnumerateObject())
                    {
                        if (property0.NameEquals("repositoryAccess"u8))
                        {
                            if (property0.Value.ValueKind == JsonValueKind.Null)
                            {
                                property0.ThrowNonNullablePropertyIsNull();
                                continue;
                            }
                            foreach (var property1 in property0.Value.EnumerateObject())
                            {
                                if (property1.NameEquals("kind"u8))
                                {
                                    kind = new RepositoryAccessKind(property1.Value.GetString());
                                    continue;
                                }
                                if (property1.NameEquals("code"u8))
                                {
                                    code = property1.Value.GetString();
                                    continue;
                                }
                                if (property1.NameEquals("state"u8))
                                {
                                    state = property1.Value.GetString();
                                    continue;
                                }
                                if (property1.NameEquals("clientId"u8))
                                {
                                    clientId = property1.Value.GetString();
                                    continue;
                                }
                                if (property1.NameEquals("token"u8))
                                {
                                    token = property1.Value.GetString();
                                    continue;
                                }
                                if (property1.NameEquals("installationId"u8))
                                {
                                    installationId = property1.Value.GetString();
                                    continue;
                                }
                            }
                            continue;
                        }
                    }
                    continue;
                }
                if (options.Format != "W")
                {
                    rawDataDictionary.Add(property.Name, BinaryData.FromString(property.Value.GetRawText()));
                }
            }
            serializedAdditionalRawData = rawDataDictionary;
            return new RepositoryAccessProperties(
                kind,
                code,
                state,
                clientId,
                token,
                installationId,
                serializedAdditionalRawData);
        }

        BinaryData IPersistableModel<RepositoryAccessProperties>.Write(ModelReaderWriterOptions options)
        {
            var format = options.Format == "W" ? ((IPersistableModel<RepositoryAccessProperties>)this).GetFormatFromOptions(options) : options.Format;

            switch (format)
            {
                case "J":
                    return ModelReaderWriter.Write(this, options);
                default:
                    throw new FormatException($"The model {nameof(RepositoryAccessProperties)} does not support writing '{options.Format}' format.");
            }
        }

        RepositoryAccessProperties IPersistableModel<RepositoryAccessProperties>.Create(BinaryData data, ModelReaderWriterOptions options)
        {
            var format = options.Format == "W" ? ((IPersistableModel<RepositoryAccessProperties>)this).GetFormatFromOptions(options) : options.Format;

            switch (format)
            {
                case "J":
                    {
                        using JsonDocument document = JsonDocument.Parse(data);
                        return DeserializeRepositoryAccessProperties(document.RootElement, options);
                    }
                default:
                    throw new FormatException($"The model {nameof(RepositoryAccessProperties)} does not support reading '{options.Format}' format.");
            }
        }

        string IPersistableModel<RepositoryAccessProperties>.GetFormatFromOptions(ModelReaderWriterOptions options) => "J";
    }
}
